/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.stepper;

import com.dassault.cecilia.core.cecilia.stepper.ViewNode;
import com.dassault.cecilia.core.cecilia.stepper.ViewRoot;
import com.dassault.cecilia.core.cecilia.stepper.ViewValue;
import java.util.ArrayList;
import java.util.List;

public class ViewDomain
implements ViewNode {
    List<ViewValue> _values;
    int _id;
    ViewRoot _root;

    public ViewDomain(int id, ViewRoot root) {
        this._id = id;
        this._root = root;
        List values = this._root.getStepper().getValuesOfDomain(id);
        this._values = new ArrayList<ViewValue>();
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                this._values.add(new ViewValue((String)values.get(i)));
            }
        } else {
            switch (id) {
                case 0: {
                    this._values.add(new ViewValue("false"));
                    this._values.add(new ViewValue("true"));
                    break;
                }
                case 1: {
                    this._values.add(new ViewValue("[Int]"));
                    break;
                }
                case 2: {
                    this._values.add(new ViewValue("[Float]"));
                }
            }
        }
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public String getName() {
        return "Domain [" + this._id + "]";
    }

    @Override
    public int getChildCount() {
        return this._values.size();
    }

    @Override
    public ViewNode getChildAt(int idx) {
        return this._values.get(idx);
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    public String toString() {
        switch (this._id) {
            case 0: {
                return "bool";
            }
            case 1: {
                return "int";
            }
            case 2: {
                return "float";
            }
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        for (int i = 0; i < this._values.size(); ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this._values.get(i).getName());
        }
        buffer.append("}");
        return buffer.toString();
    }

    public boolean isEnum() {
        return this._id != 1 && this._id != 2;
    }

    public ViewValue verifyValue(String test) {
        switch (this._id) {
            case 1: {
                try {
                    Long.parseLong(test);
                    return this._values.get(0);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 2: {
                try {
                    Double.parseDouble(test);
                    return this._values.get(0);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        for (int i = 0; i < this._values.size(); ++i) {
            ViewValue vv = this._values.get(i);
            if (!vv.getName().equals(test)) continue;
            return vv;
        }
        return null;
    }

    @Override
    public boolean findWithInstance(Class type) {
        return type.isInstance(this);
    }
}

