/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.stepper;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.stepper.ViewData;
import com.dassault.cecilia.core.cecilia.stepper.ViewEvent;
import com.dassault.cecilia.core.cecilia.stepper.ViewFlow;
import com.dassault.cecilia.core.cecilia.stepper.ViewFolder;
import com.dassault.cecilia.core.cecilia.stepper.ViewListener;
import com.dassault.cecilia.core.cecilia.stepper.ViewRoot;
import com.dassault.cecilia.core.cecilia.stepper.ViewState;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class ViewStepper {
    private static Logger _LOG = Logger.getLogger(ViewStepper.class.getPackage().getName());
    private Map<String, ViewVariable> _variables;
    private Map<String, ViewEvent> _events;
    protected ViewRoot _root;
    private EventListenerList _listeners = new EventListenerList();
    protected Component _parentComponent;
    protected Stepper _connect = null;

    public ViewVariable getVariable(String name) {
        return this._variables.get(name);
    }

    public ViewEvent getEvent(String name) {
        return this._events.get(name);
    }

    public ViewRoot getRoot() {
        return this._root;
    }

    protected void addTransition(ViewTransition tr) {
        String name;
        ViewEvent evt;
        ViewFolder node = this.getRoot().createPath(tr.getPath());
        if (node == null) {
            System.out.println("createPath(" + tr.getPath() + ") return null");
        } else {
            node.addChild(tr);
        }
        if (this._connect.withSimul()) {
            try {
                tr.setValid(this._connect.isValidTransition(tr.getId()));
            }
            catch (StepperException e) {
                e.printStackTrace();
                tr.setValid(0.0);
            }
        }
        if ((evt = this._events.get(name = tr.getFinalName())) == null) {
            evt = new ViewEvent(name);
            this._events.put(name, evt);
        }
        evt.addTrans(tr);
    }

    protected void addState(ViewVariable var) {
        ViewFolder node = this.getRoot().createPath(var.getPath());
        node.addChild(var);
        var.setDValue(this._connect.getValueOfState(var.getId()));
        var.setSValue(this._connect.getValueStringOfState(var.getId()));
        this._variables.put(var.getFinalName(), var);
    }

    protected void addFlow(ViewVariable var) {
        ViewFolder node = this.getRoot().createPath(var.getPath());
        node.addChild(var);
        var.setDValue(this._connect.getValueOfFlow(var.getId()));
        var.setSValue(this._connect.getValueStringOfFlow(var.getId()));
        this._variables.put(var.getFinalName(), var);
    }

    public void setParentComponent(Component c) {
        this._parentComponent = c;
    }

    public ViewStepper() {
        this._root = new ViewRoot(this);
        this._root.setDepth(3);
        this._variables = new HashMap<String, ViewVariable>();
        this._events = new HashMap<String, ViewEvent>();
    }

    public boolean isConnected() {
        return this._connect != null;
    }

    public void open(Stepper stepper) throws StepperException {
        this._root = new ViewRoot(this);
        this._root.setDepth(3);
        this._connect = stepper;
        if (this.changeOption()) {
            StepperException exc;
            block7: {
                exc = null;
                try {
                    this._connect.goInitialState();
                }
                catch (StepperException e) {
                    exc = e;
                }
                try {
                    this.initPostOpen();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (exc != null) break block7;
                    exc = e instanceof StepperException ? (StepperException)((Object)e) : new StepperException(e.getMessage());
                }
            }
            if (exc != null) {
                throw exc;
            }
        } else {
            throw new StepperException(ResMsgCore.getString("SIM_ERR_OPTIONS"));
        }
    }

    public boolean changeOption() {
        return true;
    }

    public void close() {
        this._root = new ViewRoot(null);
        this._root.setDepth(3);
        this._variables.clear();
        this._events.clear();
        this._connect = null;
    }

    protected void initPostOpen() throws StepperException {
        String name;
        int i;
        int nbr = this._connect.getNbrTransition();
        for (i = 1; i <= nbr; ++i) {
            name = this._connect.getNameOfTransition(i);
            String desc = this._connect.getDescOfTransition(i);
            this.addTransition(new ViewTransition(i, name, desc));
        }
        nbr = this._connect.getNbrState();
        for (i = 1; i <= nbr; ++i) {
            name = this._connect.getNameOfState(i);
            this.addState(new ViewState(i, name));
        }
        nbr = this._connect.getNbrFlow();
        try {
            for (i = 1; i <= nbr; ++i) {
                name = this._connect.getNameOfFlow(i);
                this.addFlow(new ViewFlow(i, name));
            }
        }
        catch (Exception e) {
            _LOG.log(Level.SEVERE, "Exception during addFlow for ID = " + i, e);
            throw new StepperException(ResMsgCore.msgFormat("MSG_INTERNAL_ERROR", e.getMessage()));
        }
        this._root.sortChild();
        this.updateData(false, false);
        this.fireAltaModelChanged();
    }

    public ViewData findViewData(String filter) {
        if (this._root == null) {
            return null;
        }
        return this._root.getData(filter, false);
    }

    protected void updateData(boolean notify, boolean razChange) throws StepperException {
    }

    public String getCurrentLoop() {
        String param = "???";
        if (this._connect != null) {
            param = Integer.toString(this._connect.getCurrentCycle());
        }
        return ResMsgCore.msgFormat("PAN_STEP_CYCLE", param);
    }

    public String getCurrentTime() {
        String param = "???";
        if (this._connect != null) {
            param = Double.toString(this._connect.getCurrentTime());
        }
        return ResMsgCore.msgFormat("PAN_STEP_TIME", param);
    }

    public void addAltaListener(ViewListener l) {
        this._listeners.add(ViewListener.class, l);
    }

    public void removeAltaListener(ViewListener l) {
        this._listeners.remove(ViewListener.class, l);
    }

    protected void fireAltaModelChanged() {
        Object[] alllistener = this._listeners.getListenerList();
        for (int i = alllistener.length - 2; i >= 0; i -= 2) {
            ((ViewListener)alllistener[i + 1]).altaModelChanged(this);
        }
    }

    protected void fireAltaTransitionUpdate(ViewTransition tr) {
        Object[] alllistener = this._listeners.getListenerList();
        for (int i = alllistener.length - 2; i >= 0; i -= 2) {
            ((ViewListener)alllistener[i + 1]).altaTransitionUpdate(tr);
        }
    }

    protected void fireAltaStateUpdate(ViewVariable state) {
        Object[] alllistener = this._listeners.getListenerList();
        for (int i = alllistener.length - 2; i >= 0; i -= 2) {
            ((ViewListener)alllistener[i + 1]).altaStateUpdate(state);
        }
    }

    protected void fireAltaFlowUpdate(ViewVariable flow) {
        Object[] alllistener = this._listeners.getListenerList();
        for (int i = alllistener.length - 2; i >= 0; i -= 2) {
            ((ViewListener)alllistener[i + 1]).altaFlowUpdate(flow);
        }
    }

    protected void fireAltaOtherUpdate(int type, Object data) {
        Object[] alllistener = this._listeners.getListenerList();
        for (int i = alllistener.length - 2; i >= 0; i -= 2) {
            ((ViewListener)alllistener[i + 1]).altaOtherUpdate(type, data);
        }
    }
}

