/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.user;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.user.User;
import com.dassault.cecilia.core.cecilia.user.UserRenderer;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class UserSelectDlg
extends JDialogCecilia {
    Collection<User> _users;
    String _defaultUser = null;
    private static final String KEY_INPUT = "Input";
    private JLabel _usernameLabel;
    private JComboBox _usernameValue;
    private JLabel _passwordLabel;
    private JPasswordField _passwordValue;
    private JButton _validateButton;
    private JButton _cancelButton;
    private static final String KEY_MSG = "Msg";
    private JLabel _message;
    private JButton _okButton;
    private boolean _return = false;
    boolean _bCreate = false;
    CardLayout _rightLayout = new CardLayout();
    JPanel _rightPanel = new JPanel(this._rightLayout);
    CardLayout _bottomLayout = new CardLayout();
    JPanel _bottomPanel = new JPanel(this._bottomLayout);

    public void setUsers(Collection<? extends User> users) {
        this._users = new TreeSet<User>(new Comparator<User>(){

            @Override
            public int compare(User u1, User u2) {
                return u1.getName().compareTo(u2.getName());
            }
        });
        this._users.addAll(users);
    }

    public void setDefaultUser(String defUser) {
        this._defaultUser = defUser;
    }

    public UserSelectDlg(Window parent) {
        super(parent, ResMsgVoc.getString("VOC_IDENTIFICATION"), true);
    }

    public boolean showDialog() {
        if (!this._bCreate) {
            this._bCreate = true;
            this.create();
        }
        this.setLocationRelativeTo(this.getParent());
        this._passwordValue.requestFocus();
        this.setVisible(true);
        return this._return;
    }

    private void create() {
        this.init();
        this.makePanel();
        this.setResizable(false);
        this.pack();
        this.setSize(400, this.getSize().height);
    }

    public void makePanel() {
        Container mainPanel = this.getContentPane();
        mainPanel.setLayout(new GridBagLayout());
        Image img = ResIcoCore.getInstance().getImage("SES_CONNECT", 180, 180);
        if (img != null) {
            JLabel icon = new JLabel(new ImageIcon(img));
            mainPanel.add((Component)icon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        }
        JPanel identPanel = new JPanel(new GridLayout(4, 1));
        this._usernameLabel = new JLabel(ResMsgVoc.getString("VOC_LOGIN"));
        identPanel.add(this._usernameLabel);
        this._usernameValue = new JComboBox();
        this._usernameValue.setRenderer(new UserRenderer());
        this._usernameValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                User user = UserSelectDlg.this.getUser();
                if (user == null) {
                    return;
                }
                if (UserSelectDlg.this._defaultUser != null && UserSelectDlg.this._defaultUser.equalsIgnoreCase(user.getName())) {
                    UserSelectDlg.this._passwordValue.setVisible(false);
                    UserSelectDlg.this._passwordLabel.setVisible(false);
                } else {
                    UserSelectDlg.this._passwordValue.setVisible(true);
                    UserSelectDlg.this._passwordLabel.setVisible(true);
                }
            }
        });
        this._usernameValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    UserSelectDlg.this.validAction();
                }
            }
        });
        identPanel.add(this._usernameValue);
        this._passwordLabel = new JLabel(ResMsgVoc.getString("VOC_PASSWORD"));
        identPanel.add(this._passwordLabel);
        this._passwordValue = new JPasswordField("");
        this._passwordValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    UserSelectDlg.this.validAction();
                }
            }
        });
        identPanel.add(this._passwordValue);
        this._rightPanel.add((Component)identPanel, KEY_INPUT);
        JPanel msgPanel = new JPanel(new GridBagLayout());
        this._message = new JLabel(ResMsgCore.getString("MSG_USR_ERR_PASSWD"));
        this._message.setForeground(Color.red);
        msgPanel.add((Component)this._message, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._rightPanel.add((Component)msgPanel, KEY_MSG);
        mainPanel.add((Component)this._rightPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        AbstractAction validAct = new AbstractAction(ResMsgVoc.getString("VOC_VALIDATE")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserSelectDlg.this.validAction();
            }
        };
        this._validateButton = new JButton(validAct);
        this.putAction("CECILIA_ENTER", validAct);
        panel.add((Component)this._validateButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 5), 0, 0));
        AbstractAction cancelAct = new AbstractAction(ResMsgVoc.getString("VOC_CANCEL")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserSelectDlg.this._return = false;
                UserSelectDlg.this.setVisible(false);
            }
        };
        this._cancelButton = new JButton(cancelAct);
        this.putAction("CECILIA_CANCEL", cancelAct);
        panel.add((Component)this._cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 5, 2), 0, 0));
        this._bottomPanel.add((Component)panel, KEY_INPUT);
        panel = new JPanel(new GridBagLayout());
        this._okButton = new JButton(ResMsgVoc.getString("VOC_OK"));
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserSelectDlg.this._rightLayout.show(UserSelectDlg.this._rightPanel, UserSelectDlg.KEY_INPUT);
                UserSelectDlg.this._bottomLayout.show(UserSelectDlg.this._bottomPanel, UserSelectDlg.KEY_INPUT);
                UserSelectDlg.this._passwordValue.requestFocus();
            }
        });
        panel.add((Component)this._okButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 5, 5), 0, 0));
        this._bottomPanel.add((Component)panel, KEY_MSG);
        mainPanel.add((Component)this._bottomPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        for (User user : this._users) {
            this._usernameValue.addItem(user);
        }
    }

    public void validAction() {
        if (!this.verifyConnection()) {
            this._rightLayout.show(this._rightPanel, KEY_MSG);
            this._bottomLayout.show(this._bottomPanel, KEY_MSG);
            this._passwordValue.setText("");
            this._passwordValue.requestFocus();
        } else {
            this._return = true;
            this.setVisible(false);
        }
    }

    public boolean verifyConnection() {
        User user = this.getUser();
        if (user == null) {
            return false;
        }
        if (this._defaultUser != null && this._defaultUser.equalsIgnoreCase(user.getName())) {
            return true;
        }
        return user.checkPassword(new String(this._passwordValue.getPassword()));
    }

    public User getUser() {
        return (User)this._usernameValue.getSelectedItem();
    }

    public static void main(String[] args) {
        UserSelectDlg dlg = new UserSelectDlg(null);
        ArrayList<MainUser> users = new ArrayList<MainUser>();
        users.add(new MainUser("admin", "admin", true));
        users.add(new MainUser("user", "user", false));
        users.add(new MainUser("pthomas", "pthomas", false));
        dlg.setUsers(users);
        dlg.setDefaultUser("pthomas");
        dlg.showDialog();
        System.exit(0);
    }

    private static class MainUser
    implements User {
        String _login;
        String _passwd;
        boolean _isAdmin;

        MainUser(String login, String passwd, boolean admin) {
            this._login = login;
            this._passwd = passwd;
            this._isAdmin = admin;
        }

        @Override
        public String getName() {
            return this._login;
        }

        @Override
        public String getDescription() {
            return "Descr: " + this._login;
        }

        @Override
        public boolean isAdmin() {
            return this._isAdmin;
        }

        @Override
        public boolean checkPassword(String passwd) {
            return this._passwd.equals(passwd);
        }
    }
}

