/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.plugin;

import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlugableUtility {
    public static String getStrOpt(Plugable launcher, String key, String def) {
        String value = launcher.getOption(key);
        if (value == null || value.length() == 0) {
            return def;
        }
        return value;
    }

    public static boolean getBoolOpt(Plugable launcher, String key, boolean def) {
        String value = launcher.getOption(key);
        if (value == null || value.length() == 0) {
            return def;
        }
        return value.equalsIgnoreCase("true");
    }

    public static char getCharOpt(Plugable launcher, String key, char def) {
        String value = launcher.getOption(key);
        if (value != null && value.length() == 1) {
            return value.charAt(0);
        }
        return def;
    }

    public static int getIntOpt(Plugable launcher, String key, int def) {
        String value = launcher.getOption(key);
        if (value != null && value.length() > 0) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LogUtility.logStackTrace((Logger)LogUtility.getLog(PlugableUtility.class), (Level)Level.INFO, (String)("Option '" + key + "' is not an integer: " + def));
            }
        }
        return def;
    }

    public static long getLongOpt(Plugable launcher, String key, long def) {
        String value = launcher.getOption(key);
        if (value != null && value.length() > 0) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                LogUtility.logStackTrace((Logger)LogUtility.getLog(PlugableUtility.class), (Level)Level.INFO, (String)("Option '" + key + "' is not a long: " + def));
            }
        }
        return def;
    }

    public static double getDoubleOpt(Plugable launcher, String key, double def) {
        String value = launcher.getOption(key);
        if (value != null && value.length() > 0) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                LogUtility.logStackTrace((Logger)LogUtility.getLog(PlugableUtility.class), (Level)Level.INFO, (String)("Option '" + key + "' is not a double: " + def));
            }
        }
        return def;
    }
}

