/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.Util;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMProcess;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.pluginmanager.PostProcessItem;
import com.dassault.cecilia.core.pluginmanager.PostProcessStore;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.w3c.dom.Node;

class PostProcess
implements PluginMProcess {
    String _name;
    String _remark = "";
    String _filter = "";
    List<PostProcessItem> _items = new ArrayList<PostProcessItem>();
    static final Pattern PATTERN_NAME = Pattern.compile("[A-Za-z][A-Za-z0-9\\-\\_/]*");

    PostProcess() {
    }

    public PostProcess(String name) {
        this();
        this._name = name;
        this._filter = "";
        this._remark = "";
    }

    boolean load(Node data, PluginManager manager) {
        Node attr = data.getAttributes().getNamedItem("NAME");
        if (attr == null) {
            PostProcessStore.__logger.severe("POST_PROCESS without NAME attribute");
            return false;
        }
        this._name = attr.getNodeValue();
        attr = data.getAttributes().getNamedItem("REMARK");
        if (attr != null) {
            this._remark = attr.getNodeValue();
        }
        if ((attr = data.getAttributes().getNamedItem("FILTER")) != null && !this.setFilter(attr.getNodeValue())) {
            PostProcessStore.__logger.warning("FILTER attribute for POST_PROCESS element error format ");
        }
        for (Node child = data.getFirstChild(); child != null; child = child.getNextSibling()) {
            PostProcessItem pp;
            if (child.getNodeType() != 1 || !child.getNodeName().equals("TREATMENT") || !(pp = new PostProcessItem()).load(child, manager)) continue;
            this.add(pp);
        }
        return true;
    }

    void save(BufferedWriter out, PluginManager manager) throws IOException {
        int size;
        out.write("  <");
        out.write("POST_PROCESS");
        out.write(" ");
        out.write("NAME");
        out.write("=\"");
        out.write(this._name);
        out.write("\"");
        if (this._filter.length() > 0) {
            out.write(" ");
            out.write("FILTER");
            out.write("=\"");
            out.write(this._filter);
            out.write("\"");
        }
        if (this._remark.length() > 0) {
            out.write(" ");
            out.write("REMARK");
            out.write("=\"");
            out.write(Util.formatStringForXml(this._remark));
            out.write("\"");
        }
        if ((size = this._items.size()) > 0) {
            out.write(">");
            out.newLine();
            for (int i = 0; i < size; ++i) {
                this.get(i).save(out, manager);
            }
            out.write("  </");
            out.write("POST_PROCESS");
            out.write(">");
        } else {
            out.write("/>");
        }
        out.newLine();
    }

    String getName() {
        return this._name;
    }

    boolean setName(String val) {
        if (!PATTERN_NAME.matcher(val).matches()) {
            return false;
        }
        this._name = val;
        return true;
    }

    String getRemark() {
        return this._remark;
    }

    void setRemark(String val) {
        this._remark = val;
    }

    String getFilter() {
        return this._filter;
    }

    boolean setFilter(String filter) {
        filter = filter.trim();
        StringTokenizer st = new StringTokenizer(filter, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (PATTERN_NAME.matcher(token).matches()) continue;
            return false;
        }
        this._filter = filter;
        return true;
    }

    public String toString() {
        return this._name;
    }

    int size() {
        return this._items.size();
    }

    PostProcessItem get(int index) {
        return this._items.get(index);
    }

    void set(int index, PostProcessItem item) {
        this._items.set(index, item);
    }

    int indexOf(PostProcessItem obj) {
        return this._items.indexOf(obj);
    }

    void add(PostProcessItem obj) {
        this._items.add(obj);
    }

    void add(int idx, PostProcessItem obj) {
        this._items.add(idx, obj);
    }

    PostProcessItem remove(int index) {
        return this._items.remove(index);
    }

    @Override
    public boolean withCriterium(String filter) {
        if (this._items.size() == 0) {
            return false;
        }
        if (this._filter.trim().length() == 0) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(this._filter, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (!filter.equalsIgnoreCase(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String writeDefine(Plugable launcher) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("  <function id='").append(this.getName()).append("'>\n");
        sb.append("    <local name='rfile'/>\n");
        sb.append("    <local name='log.path'/>\n");
        sb.append("    <block>\n");
        sb.append("      <set name='file' global='false'> <finfo file='%{rfile}' pattern='%F'/> </set>\n");
        sb.append("      <set name='path' global='false'> <finfo file='%{rfile}' pattern='%P'/> </set>\n");
        sb.append("      <set name='name' global='false'> <finfo file='%{rfile}' pattern='%n'/> </set>\n");
        sb.append("      <set name='ext' global='false'> <finfo file='%{rfile}' pattern='%e'/> </set>\n");
        sb.append("      <set name='log.format' global='false'> <get property='log.format' defvalue='txt'/> </set>\n");
        sb.append("    \n");
        int size = this._items.size();
        for (int i = 0; i < size; ++i) {
            String append = this.get(i).getPlugin().writeDefine(launcher, this.get(i).getParam());
            if (append == null || append.length() <= 0) continue;
            sb.append(append).append("\n");
        }
        sb.append("    \n");
        sb.append("    </block>\n");
        sb.append("  </function>\n");
        return sb.toString();
    }

    @Override
    public String writeCommand(Plugable launcher, String filePath, String logPath) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("  <callfunct ref='").append(this.getName()).append("'>\n");
        sb.append("    <value value='").append(filePath.replace('\\', '/')).append("'/>\n");
        sb.append("    <value value='").append(logPath.replace('\\', '/')).append("'/>\n");
        sb.append("  </callfunct>\n");
        return sb.toString();
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return false;
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        return null;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
    }

    @Override
    public boolean validOptions(Plugable launcher) {
        return false;
    }

    @Override
    public boolean withParameters() {
        return false;
    }

    @Override
    public Object changeParameters(PluginManager parent, Object parameters) {
        return null;
    }

    @Override
    public Object getDefaultParameters(PluginManager plugable) {
        return null;
    }

    @Override
    public IOParameters getIOParameters() {
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        return null;
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return this.getName();
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return this.getRemark();
        }
        if (key.equals("type")) {
            return "PlugProcess";
        }
        if (key.equals("plugin.key")) {
            return PostProcessStore.class.getName() + "." + this.getName();
        }
        if (key.equals("plugin.version")) {
            return "1.01";
        }
        return null;
    }
}

