/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.plugin.PluginMTreatment;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.pluginmanager.PostProcessStore;
import java.io.BufferedWriter;
import java.io.IOException;
import org.w3c.dom.Node;

class PostProcessItem {
    PluginMTreatment _plugin;
    String _name;
    Object _params;

    PostProcessItem() {
    }

    PostProcessItem(PluginMTreatment plugin, PluginManager manager) {
        this._plugin = plugin;
        if (plugin.withParameters()) {
            this._params = plugin.getDefaultParameters(manager);
        }
    }

    String getPluginName() {
        return this._plugin.getInfo("plugin.name");
    }

    String getPluginKey() {
        return this._plugin.getInfo("plugin.key");
    }

    PluginMTreatment getPlugin() {
        return this._plugin;
    }

    String getName() {
        return this._name;
    }

    void setName(String value) {
        this._name = value;
    }

    Object getParam() {
        return this._params;
    }

    void setParam(Object value) {
        this._params = value;
    }

    boolean load(Node data, PluginManager manager) {
        Node attr = data.getAttributes().getNamedItem("NAME");
        if (attr == null) {
            PostProcessStore.__logger.severe("TREATMENT without NAME attribute");
            return false;
        }
        this._name = attr.getNodeValue();
        attr = data.getAttributes().getNamedItem("ID");
        if (attr == null) {
            PostProcessStore.__logger.severe("TREATMENT without ID attribute");
            return false;
        }
        PluginModel plugin = manager.getPlugin(attr.getNodeValue());
        if (plugin == null) {
            PostProcessStore.__logger.severe("PluginModel '" + attr.getNodeValue() + "' is unknow");
            return false;
        }
        if (!(plugin instanceof PluginMTreatment)) {
            PostProcessStore.__logger.severe("PluginModel '" + attr.getNodeValue() + "' is not PluginMTreatment");
            return false;
        }
        this._plugin = (PluginMTreatment)plugin;
        if (this._plugin.withParameters()) {
            for (Node child = data.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.getNodeName().equals(this._plugin.getInfo("plugin.parameterTag"))) continue;
                this._params = this._plugin.getIOParameters().readXML(child, manager);
                if (this._params != null) continue;
                PostProcessStore.__logger.severe("Error during read parameter of PluginModel '" + this.getPluginKey() + "'");
                return false;
            }
            if (this._params == null) {
                PostProcessStore.__logger.warning("No parameter for PluginModel '" + this.getPluginKey() + "' : use default parameter");
                this._params = this._plugin.getDefaultParameters(manager);
            }
        }
        return true;
    }

    void save(BufferedWriter out, PluginManager manager) throws IOException {
        out.write("    <");
        out.write("TREATMENT");
        out.write(" ");
        out.write("NAME");
        out.write("=\"");
        out.write(this._name);
        out.write("\"");
        out.write(" ");
        out.write("ID");
        out.write("=\"");
        out.write(this.getPluginKey());
        out.write("\"");
        if (this._params == null) {
            out.write("/>");
        } else {
            out.write(">");
            out.newLine();
            this._plugin.getIOParameters().writeXML(out, this._params, manager);
            out.write("    </");
            out.write("TREATMENT");
            out.write(">");
        }
        out.newLine();
    }
}

