/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.pluginmanager.ErrorManager;
import com.dassault.cecilia.core.pluginmanager.Messages;
import com.dassault.cecilia.core.pluginmanager.Util;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceAccessor {
    private static ResourceAccessor instance;
    private static final Logger _LOG;
    private static final String PLUGIN_BUNDLE_NAME;
    private static ResourceBundle PLUGIN_RESOURCE_BUNDLE;

    public static ResourceAccessor getInstance() {
        return instance == null ? new ResourceAccessor() : instance;
    }

    public URL getResource(String key) {
        String name = this.getResourceString(key);
        if (name != null) {
            return this.getClass().getResource(name);
        }
        String msg = Util.FormatString(Messages.getString("ResourceAccessor.0"), key);
        new ErrorManager().displayError(null, msg);
        return null;
    }

    public String getResourceString(String nm) {
        String str;
        try {
            str = PLUGIN_RESOURCE_BUNDLE.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private ResourceAccessor() {
    }

    public static void main(String[] args) {
    }

    static {
        _LOG = Logger.getLogger(ResourceAccessor.class.getPackage().getName());
        PLUGIN_BUNDLE_NAME = ResourceAccessor.class.getPackage().getName() + ".plugin";
        try {
            PLUGIN_RESOURCE_BUNDLE = ResourceBundle.getBundle(PLUGIN_BUNDLE_NAME);
        }
        catch (MissingResourceException mre) {
            _LOG.log(Level.SEVERE, "Resource file not found: " + PLUGIN_BUNDLE_NAME.replace('.', '/') + ".properties", mre);
            System.exit(1);
        }
    }
}

