/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DlgPanelTime
extends JPanel {
    private JComboBox _timeValueHours = new JComboBox();
    private JComboBox _timeValueMinutes = new JComboBox();
    private JComboBox _timeValueSeconds = new JComboBox();
    private JLabel _timeUnitHours = new JLabel(ResMsgCore.getString("DLG_PARAM_TIME_HH"));
    private JLabel _timeUnitMinutes = new JLabel(ResMsgCore.getString("DLG_PARAM_TIME_MIN"));
    private JLabel _timeUnitSeconds = new JLabel(ResMsgCore.getString("DLG_PARAM_TIME_SEC"));

    public DlgPanelTime() {
        this.make();
    }

    private void make() {
        int i;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        for (i = 0; i < 24; ++i) {
            this._timeValueHours.addItem(new String("" + i));
        }
        for (i = 0; i < 60; ++i) {
            this._timeValueMinutes.addItem(new String("" + i));
            this._timeValueSeconds.addItem(new String("" + i));
        }
        this._timeValueHours.setEditable(true);
        ((JTextField)this._timeValueHours.getEditor().getEditorComponent()).setColumns(3);
        ((JTextField)this._timeValueHours.getEditor().getEditorComponent()).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                try {
                    Integer.parseInt(((JTextField)DlgPanelTime.this._timeValueHours.getEditor().getEditorComponent()).getText());
                }
                catch (NumberFormatException ex) {
                    DlgPanelTime.this._timeValueHours.setSelectedIndex(1);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        int idxX = 0;
        this.add((Component)this._timeValueHours, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.add((Component)this._timeUnitHours, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.add((Component)this._timeValueMinutes, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.add((Component)this._timeUnitMinutes, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.add((Component)this._timeValueSeconds, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.add((Component)this._timeUnitSeconds, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(idxX++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 0, 0));
        this._timeValueHours.setSelectedIndex(1);
        this._timeValueMinutes.setSelectedIndex(0);
        this._timeValueSeconds.setSelectedIndex(0);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._timeValueHours.setEnabled(enabled);
        this._timeValueMinutes.setEnabled(enabled);
        this._timeValueSeconds.setEnabled(enabled);
    }

    public void setComputeTime(Double time) {
        if (time != null) {
            int intTime = (int)time.doubleValue();
            int hours = intTime / 3600;
            int minutes = (intTime -= hours * 3600) / 60;
            int secondes = intTime -= minutes * 60;
            ((JTextField)this._timeValueHours.getEditor().getEditorComponent()).setText("" + hours);
            this._timeValueMinutes.setSelectedIndex(minutes);
            this._timeValueSeconds.setSelectedIndex(secondes);
        } else {
            ((JTextField)this._timeValueHours.getEditor().getEditorComponent()).setText("");
            this._timeValueMinutes.setSelectedItem(null);
            this._timeValueSeconds.setSelectedItem(null);
        }
    }

    public void setComputeTime(Integer hours, Integer mins, Integer secs) {
        ((JTextField)this._timeValueHours.getEditor().getEditorComponent()).setText(hours != null ? hours.toString() : "");
        this._timeValueMinutes.setSelectedItem(mins == null ? null : String.valueOf(mins));
        this._timeValueSeconds.setSelectedItem(secs == null ? null : String.valueOf(secs));
    }

    public Double getComputeTime() {
        String hoursStr = ((JTextField)this._timeValueHours.getEditor().getEditorComponent()).getText();
        if ((hoursStr == null || hoursStr.isEmpty()) && this._timeValueMinutes.getSelectedItem() == null && this._timeValueSeconds.getSelectedItem() == null) {
            return null;
        }
        if (hoursStr == null || hoursStr.isEmpty() || this._timeValueMinutes.getSelectedItem() == null || this._timeValueSeconds.getSelectedItem() == null) {
            return -1.0;
        }
        return (double)Integer.parseInt(hoursStr) * 3600.0 + (double)this._timeValueMinutes.getSelectedIndex() * 60.0 + (double)this._timeValueSeconds.getSelectedIndex();
    }

    public static String formatMissionTime(double timeSec) {
        int intTime = (int)timeSec;
        int hours = intTime / 3600;
        int minutes = (intTime -= hours * 3600) / 60;
        int secondes = intTime -= minutes * 60;
        StringBuffer sb = new StringBuffer();
        if (hours < 10) {
            sb.append("0");
        }
        sb.append(hours).append(" ").append(ResMsgCore.getString("DLG_PARAM_TIME_HH")).append(" ");
        if (minutes < 10) {
            sb.append("0");
        }
        sb.append(minutes).append(" ").append(ResMsgCore.getString("DLG_PARAM_TIME_MIN")).append(" ");
        if (secondes < 10) {
            sb.append("0");
        }
        sb.append(secondes).append(" ").append(ResMsgCore.getString("DLG_PARAM_TIME_SEC")).append(" ");
        return sb.toString();
    }

    public static void main(String[] args) {
        int nbrTrace = 10;
        int cs = 0;
        int cm = 0;
        int ch = 0;
        while (ch != 24) {
            double time = (double)ch * 3600.0 + (double)cm * 60.0 + (double)cs;
            int intTime = (int)time;
            int th = intTime / 3600;
            int tm = (intTime -= th * 3600) / 60;
            int ts = intTime -= tm * 60;
            if (ch != th || cm != tm || cs != ts) {
                System.out.println("Diff for time : " + time + " c=" + ch + "h" + cm + "m" + cs + "s c=" + th + "h" + tm + "m" + ts + "s");
                if (--nbrTrace <= 0) break;
            }
            if (++cs < 60) continue;
            cs = 0;
            if (++cm < 60) continue;
            cm = 0;
            ++ch;
        }
    }
}

