/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class JOptionCecilia {
    public static Component getTopContainerOf(Component component) {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Window) {
            return component;
        }
        if (component instanceof JInternalFrame) {
            return component;
        }
        JInternalFrame iframe = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, component);
        if (iframe != null) {
            return iframe;
        }
        return SwingUtilities.getWindowAncestor(component);
    }

    public static Window getWindowOf(Component component) {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return SwingUtilities.getWindowAncestor(component);
    }

    public static String getTopTitleOf(Component component) {
        if (component == null) {
            return "Cecilia WorkShop";
        }
        if (component instanceof JInternalFrame) {
            return ((JInternalFrame)component).getTitle();
        }
        JInternalFrame iframe = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, component);
        if (iframe != null) {
            return iframe.getTitle();
        }
        Window win = SwingUtilities.getWindowAncestor(component);
        if (win instanceof Dialog) {
            return ((Dialog)win).getTitle();
        }
        if (win instanceof Frame) {
            return ((Frame)win).getTitle();
        }
        return "Cecilia WorkShop";
    }

    public static void showMessageDialog(Component owner, String msg, String title, int type) {
        StringBuilder html = new StringBuilder(msg.length() + 100);
        html.append("<html>\n");
        StringTokenizer st = new StringTokenizer(msg, "\n", false);
        int width = 0;
        int height = 0;
        while (st.hasMoreTokens()) {
            int idx;
            String line = st.nextToken();
            width = Math.max(line.length(), width);
            if (height > 0) {
                html.append("<br/>\n");
            }
            for (idx = 0; idx < line.length(); ++idx) {
                char car = line.charAt(idx);
                if (car == '\t') {
                    html.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    continue;
                }
                if (car != ' ') break;
                html.append("&nbsp;");
            }
            html.append(line.substring(idx));
            ++height;
        }
        html.append("\n</html>");
        if (width > 120 || height > 8) {
            JTextArea ctrlMess = new JTextArea();
            ctrlMess.setLineWrap(false);
            ctrlMess.setWrapStyleWord(false);
            ctrlMess.setEditable(false);
            ctrlMess.setTabSize(4);
            ctrlMess.setText(msg);
            JScrollPane scrMess = new JScrollPane(ctrlMess);
            scrMess.setPreferredSize(new Dimension(500, 300));
            JOptionPaneResizable optionPanel = new JOptionPaneResizable(scrMess, type);
            JDialog dlg = optionPanel.createDialog(JOptionCecilia.getTopContainerOf(owner), title);
            dlg.setVisible(true);
            dlg.dispose();
        } else {
            if (height > 1) {
                msg = html.toString();
            }
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(owner), new JLabel(msg), title, type);
        }
    }

    public static void ensureDialogIsIntoScreen(JDialog dlg) {
        Point pt = dlg.getLocation();
        Rectangle dlgBounds = dlg.getBounds();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle bounds = gc.getBounds();
            if (!bounds.contains(pt)) continue;
            if (bounds.contains(dlgBounds)) {
                return;
            }
            if (dlgBounds.x + dlgBounds.width > bounds.x + bounds.width) {
                pt.x = bounds.x + bounds.width - dlgBounds.width;
            }
            if (dlgBounds.y + dlgBounds.height > bounds.y + bounds.height) {
                pt.y = bounds.y + bounds.height - dlgBounds.height;
            }
            dlg.setLocation(pt);
        }
    }

    public static GraphicsConfiguration getGraphicConfiguration(Point pt) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle bounds = gc.getBounds();
            if (!bounds.contains(pt)) continue;
            return gc;
        }
        return null;
    }

    public static void showPopupMenu(JPopupMenu popupMenu, Point point, Component container) {
        popupMenu.show(container, point.x, point.y);
    }

    public static class JOptionPaneResizable
    extends JOptionPane {
        public JOptionPaneResizable() {
        }

        public JOptionPaneResizable(Object msg) {
            super(msg);
        }

        public JOptionPaneResizable(Object msg, int msgType) {
            super(msg, msgType);
        }

        public JOptionPaneResizable(Object msg, int msgType, int optType) {
            super(msg, msgType, optType);
        }

        public JOptionPaneResizable(Object msg, int msgType, int optType, Icon ico) {
            super(msg, msgType, optType, ico);
        }

        public JOptionPaneResizable(Object msg, int msgType, int optType, Icon ico, Object[] opts) {
            super(msg, msgType, optType, ico, opts);
        }

        public JOptionPaneResizable(Object msg, int msgType, int optType, Icon ico, Object[] opts, Object initValue) {
            super(msg, msgType, optType, ico, opts, initValue);
        }

        @Override
        public JDialog createDialog(Component parentComponent, String title) throws HeadlessException {
            JDialog dialog = super.createDialog(parentComponent, title);
            dialog.setResizable(true);
            return dialog;
        }

        @Override
        public JInternalFrame createInternalFrame(Component parentComponent, String title) {
            JInternalFrame frame = super.createInternalFrame(parentComponent, title);
            frame.setResizable(true);
            return frame;
        }
    }
}

