/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class SwingUtilitiesCecilia {
    public static void setLocationRelativeTo(Window child, Component parent) {
        if (parent == null) {
            GraphicsDevice device = SwingUtilitiesCecilia.getDefaultScreenDevice();
            GraphicsConfiguration conf = device.getDefaultConfiguration();
            Rectangle winMaxbounds = SwingUtilitiesCecilia.getMaxWindowSize(conf);
            SwingUtilitiesCecilia.setLocaltionRelativeTo(child, winMaxbounds);
        } else {
            Window parentWin;
            Dimension dimension = child.getSize();
            Window window = parentWin = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
            if (parentWin == null) {
                SwingUtilitiesCecilia.setLocationRelativeTo(child, null);
                return;
            }
            Dimension parentDimension = parentWin.getSize();
            Point parentLocation = parentWin.getLocation();
            child.setLocation(new Point(parentLocation.x + parentDimension.width / 2 - dimension.width / 2, parentLocation.y + parentDimension.height / 2 - dimension.height / 2));
            SwingUtilitiesCecilia.adjustVisibility(child, parentWin);
        }
    }

    public static Rectangle getMaxWindowSize(GraphicsConfiguration conf) {
        assert (conf != null);
        Rectangle screenBounds = conf.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(conf);
        Rectangle winMaxbounds = new Rectangle((int)screenBounds.getMinX() + insets.left, (int)screenBounds.getMinY() + insets.top, (int)screenBounds.getWidth() - insets.left - insets.right, (int)screenBounds.getHeight() - insets.top - insets.bottom);
        return winMaxbounds;
    }

    public static GraphicsDevice getDefaultScreenDevice() {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int i = 0; i < devices.length; ++i) {
            Rectangle bounds = devices[i].getDefaultConfiguration().getBounds();
            if (bounds.getX() != 0.0) continue;
            return devices[i];
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    private static void setLocaltionRelativeTo(Window win, Rectangle winMaxbounds) {
        assert (win != null);
        assert (winMaxbounds != null);
        Dimension dimension = win.getSize();
        Dimension parentDimension = winMaxbounds.getSize();
        Point parentLocation = winMaxbounds.getLocation();
        win.setLocation(new Point(parentLocation.x + parentDimension.width / 2 - dimension.width / 2, parentLocation.y + parentDimension.height / 2 - dimension.height / 2));
    }

    public static void adjustVisibility(Window child, Component parent) {
        Rectangle winBounds;
        if (parent == null) {
            return;
        }
        GraphicsConfiguration conf = SwingUtilitiesCecilia.getGraphicsConfiguration(parent);
        Rectangle winMaxbounds = SwingUtilitiesCecilia.getMaxWindowSize(conf);
        if (!winMaxbounds.contains(winBounds = child.getBounds())) {
            double dx = 0.0;
            double dy = 0.0;
            if (winBounds.getMaxX() > winMaxbounds.getMaxX()) {
                dx = winMaxbounds.getMaxX() - winBounds.getMaxX();
            } else if (winBounds.getMinX() < winMaxbounds.getMinX()) {
                dx = winMaxbounds.getMinX() - winBounds.getMinX();
            }
            if (winBounds.getMaxY() > winMaxbounds.getMaxY()) {
                dy = winMaxbounds.getMaxY() - winBounds.getMaxY();
            } else if (winBounds.getMinY() < winMaxbounds.getMinY()) {
                dy = winMaxbounds.getMinY() - winBounds.getMinY();
            }
            child.setLocation((int)((double)child.getX() + dx), (int)((double)child.getY() + dy));
        }
    }

    public static GraphicsConfiguration getGraphicsConfiguration(Component comp) {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        double maxIntersectArea = 0.0;
        GraphicsDevice device = null;
        for (int i = 0; i < devices.length; ++i) {
            Rectangle winBounds;
            Rectangle screenBounds = devices[i].getDefaultConfiguration().getBounds();
            if (screenBounds.contains(winBounds = comp.getBounds())) {
                return devices[i].getDefaultConfiguration();
            }
            Rectangle inter = screenBounds.intersection(winBounds);
            double area = inter.getWidth() * inter.getHeight();
            if (!(area > maxIntersectArea)) continue;
            maxIntersectArea = area;
            device = devices[i];
        }
        if (device != null) {
            return device.getDefaultConfiguration();
        }
        return comp.getGraphicsConfiguration();
    }
}

