/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.list;

import com.dassault.cecilia.core.swing.other.AbstractCollectionPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class ListPanel
extends AbstractCollectionPanel {
    ListModel _modelList;
    protected JList _ctrlList;

    public ListPanel(ListModel model, boolean bInit, boolean bCreate) {
        super(false);
        this._modelList = model;
        if (bInit) {
            this.initialise();
        }
        if (bCreate) {
            this.createPanel();
        }
    }

    @Override
    protected JComponent createCtrlCollection() {
        this._ctrlList = new JList(this._modelList);
        this._ctrlList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int idx;
                if (SwingUtilities.isRightMouseButton(e) && !ListPanel.this._ctrlList.isSelectedIndex(idx = ListPanel.this._ctrlList.locationToIndex(e.getPoint()))) {
                    ListPanel.this._ctrlList.setSelectedIndex(idx);
                }
            }
        });
        ListSelectionModel selMod = this._ctrlList.getSelectionModel();
        selMod.setSelectionMode(0);
        selMod.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListPanel.this.refreshCtrl();
            }
        });
        this._modelList.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ListPanel.this.callRefreshCtrl();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                ListPanel.this.callRefreshCtrl();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ListPanel.this.callRefreshCtrl();
            }
        });
        return this._ctrlList;
    }

    @Override
    protected int getSelectedRow() {
        return this._ctrlList.getSelectedIndex();
    }

    @Override
    protected int getSelectedRowCount() {
        return this._ctrlList.getSelectedIndices().length;
    }

    @Override
    protected int[] getSelectedRows() {
        return this._ctrlList.getSelectedIndices();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._ctrlList.setEnabled(enabled);
    }
}

