/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.other;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.CeciliaAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public abstract class AbstractCollectionPanel
extends JPanel {
    protected JScrollPane _scrollCollection;
    protected CeciliaAction _ctrlAdd;
    protected CeciliaAction _ctrlDel;
    protected JPopupMenu _popupList;
    public static final String ACTION_ADD = "ACTION_ADD";
    public static final String ACTION_DEL = "ACTION_DEL";
    boolean _bCreatePanel = false;

    public AbstractCollectionPanel(boolean bInit) {
        super(new BorderLayout());
        if (bInit) {
            this.initialise();
        }
    }

    protected abstract void addData(int var1);

    protected abstract void delData(int[] var1);

    protected void createActions() {
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD"), ResMsgCore.getString("ACTION_ADD_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = AbstractCollectionPanel.this.getSelectedRow();
                AbstractCollectionPanel.this.addData(idx);
                AbstractCollectionPanel.this.refreshCtrl();
            }
        };
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE"), ResMsgCore.getString("ACTION_DEL_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractCollectionPanel.this.getSelectedRowCount() > 0) {
                    int[] idxs = AbstractCollectionPanel.this.getSelectedRows();
                    AbstractCollectionPanel.this.delData(idxs);
                    AbstractCollectionPanel.this.refreshCtrl();
                }
            }
        };
    }

    protected abstract JComponent createCtrlCollection();

    protected abstract int getSelectedRow();

    protected abstract int getSelectedRowCount();

    protected abstract int[] getSelectedRows();

    protected void initialise() {
        this.createActions();
        this._popupList = new JPopupMenu();
        this._popupList = this.createMenuActions(this._popupList);
        JComponent ctrlCollection = this.createCtrlCollection();
        this._scrollCollection = new JScrollPane(ctrlCollection);
        this._scrollCollection.setComponentPopupMenu(this._popupList);
        ctrlCollection.setInheritsPopupMenu(true);
        this.refreshCtrl();
    }

    public CeciliaAction getAction(String key) {
        if (ACTION_ADD.equals(key)) {
            return this._ctrlAdd;
        }
        if (ACTION_DEL.equals(key)) {
            return this._ctrlDel;
        }
        return null;
    }

    public Component getCtrlCollection() {
        return this._scrollCollection;
    }

    public Component getCtrlPanel() {
        return this.createPanel();
    }

    protected Component createPanel() {
        if (!this._bCreatePanel) {
            this.doCreatePanel();
        }
        return this;
    }

    private synchronized void doCreatePanel() {
        if (this._bCreatePanel) {
            return;
        }
        JToolBar aPanel = new JToolBar();
        aPanel.setBorder(CeciliaAction.STANDARD_BORDER);
        this.createToolBarActions(aPanel);
        aPanel.setFloatable(false);
        this.add((Component)aPanel, "North");
        this.add((Component)this._scrollCollection, "Center");
        this._bCreatePanel = true;
    }

    protected JPopupMenu createMenuActions(JPopupMenu popupList) {
        popupList.add(this._ctrlAdd);
        popupList.add(this._ctrlDel);
        return popupList;
    }

    protected void createToolBarActions(Container toolbar) {
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
    }

    protected void callRefreshCtrl() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractCollectionPanel.this.refreshCtrl();
            }
        });
    }

    protected void refreshCtrl() {
        boolean isEnabled = this.isEnabled();
        int idx = this.getSelectedRow();
        this._ctrlAdd.setEnabled(isEnabled);
        this._ctrlDel.setEnabled(isEnabled && idx != -1);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.refreshCtrl();
    }
}

