/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.other;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ComponentTitledBorder
implements Border,
MouseListener,
MouseMotionListener,
SwingConstants {
    private int _offset = 5;
    private Component _titleComponent;
    private Rectangle _titleRectangle;
    private JComponent _childrenContainer;
    private Border _titleBorder;
    private boolean _bMouseEntered = false;

    public ComponentTitledBorder(Component comp, JComponent container, Border border) {
        this._titleComponent = comp;
        this._childrenContainer = container;
        this._titleBorder = border;
        container.addMouseListener(this);
        container.addMouseMotionListener(this);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets borderInsets = this._titleBorder.getBorderInsets(c);
        Insets insets = this.getBorderInsets(c);
        int temp = (insets.top - borderInsets.top) / 2;
        this._titleBorder.paintBorder(c, g, x, y + temp, width, height - temp);
        Dimension size = this._titleComponent.getPreferredSize();
        this._titleRectangle = new Rectangle(this._offset, 0, size.width, size.height);
        SwingUtilities.paintComponent(g, this._titleComponent, (Container)c, this._titleRectangle);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Dimension size = this._titleComponent.getPreferredSize();
        Insets insets = this._titleBorder.getBorderInsets(c);
        insets.top = Math.max(insets.top, size.height);
        return insets;
    }

    private void dispatchEvent(MouseEvent me) {
        if (this._titleRectangle != null && this._titleRectangle.contains(me.getX(), me.getY())) {
            this.dispatchEvent(me, me.getID());
        }
    }

    private void dispatchEvent(MouseEvent me, int id) {
        Point pt = me.getPoint();
        pt.translate(-this._offset, 0);
        this._titleComponent.setSize(this._titleRectangle.width, this._titleRectangle.height);
        this._titleComponent.dispatchEvent(new MouseEvent(this._titleComponent, id, me.getWhen(), me.getModifiersEx(), pt.x, pt.y, me.getClickCount(), me.isPopupTrigger(), me.getButton()));
        if (!this._titleComponent.isValid()) {
            this._childrenContainer.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.dispatchEvent(me);
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
        if (this._bMouseEntered) {
            this._bMouseEntered = false;
            this.dispatchEvent(me, 505);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.dispatchEvent(me);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.dispatchEvent(me);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        if (this._titleRectangle == null) {
            return;
        }
        if (!this._bMouseEntered && this._titleRectangle.contains(me.getX(), me.getY())) {
            this._bMouseEntered = true;
            this.dispatchEvent(me, 504);
        } else if (this._bMouseEntered) {
            if (!this._titleRectangle.contains(me.getX(), me.getY())) {
                this._bMouseEntered = false;
                this.dispatchEvent(me, 505);
            } else {
                this.dispatchEvent(me, 503);
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final JPanel proxyPanel = new JPanel(new BorderLayout());
        proxyPanel.add((Component)new JLabel("Proxy Host: "), "North");
        proxyPanel.add((Component)new JTextField("proxy.xyz.com"), "Center");
        final JCheckBox checkBox = new JCheckBox("Use Proxy", true);
        checkBox.setFocusPainted(false);
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enable = checkBox.isSelected();
                Component[] comp = proxyPanel.getComponents();
                for (int i = 0; i < comp.length; ++i) {
                    comp[i].setEnabled(enable);
                }
            }
        });
        ComponentTitledBorder componentBorder = new ComponentTitledBorder(checkBox, proxyPanel, BorderFactory.createEtchedBorder());
        proxyPanel.setBorder(componentBorder);
        JFrame frame = new JFrame("ComponentTitledBorder");
        Container contents = frame.getContentPane();
        contents.setLayout(new BorderLayout());
        contents.add((Component)proxyPanel, "Center");
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

