/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.other;

import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JCRLabel
extends JPanel {
    Box _hBox;
    Box _vBox;
    FlowLayout _layout;
    JLabel _lblIcon;
    ArrayList<JLabel> _texts;

    public JCRLabel(String text, Icon icon, int horizontalAlignment) {
        this.init(text, icon, horizontalAlignment);
    }

    public JCRLabel(String text, int horizontalAlignment) {
        this.init(text, null, horizontalAlignment);
    }

    public JCRLabel(String text) {
        this.init(text, null, 2);
    }

    public JCRLabel(Icon image, int horizontalAlignment) {
        this.init("", image, horizontalAlignment);
    }

    public JCRLabel(Icon image) {
        this.init("", image, 2);
    }

    public JCRLabel() {
        this.init("", null, 2);
    }

    protected void init(String text, Icon icon, int horizontalAlignment) {
        int layoutAlignement = 0;
        if (horizontalAlignment == 0) {
            layoutAlignement = 1;
        } else if (horizontalAlignment == 4) {
            layoutAlignement = 2;
        }
        this._layout = new FlowLayout(layoutAlignement);
        this.setLayout(this._layout);
        this._hBox = Box.createHorizontalBox();
        this._vBox = Box.createVerticalBox();
        this._lblIcon = icon != null ? new JLabel(icon) : new JLabel("");
        this.add(this._hBox);
        this._hBox.add(this._lblIcon);
        this._hBox.add(this._vBox);
        JLabel lbl = new JLabel("Text");
        this._texts = new ArrayList();
        this._texts.add(lbl);
        this._vBox.add(lbl);
        this.setText(text);
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public void setText(String text) {
        this._vBox.removeAll();
        int aChar = this.getDisplayedMnemonic();
        int hAlig = this.getHorizontalAlignment();
        int vAlig = this.getVerticalAlignment();
        this._texts.clear();
        StringTokenizer st = new StringTokenizer(text, "\n");
        while (st.hasMoreTokens()) {
            String txt = st.nextToken();
            JLabel lbl = new JLabel(txt);
            lbl.setDisplayedMnemonic(aChar);
            lbl.setHorizontalAlignment(hAlig);
            lbl.setVerticalAlignment(vAlig);
            this._texts.add(lbl);
            this._vBox.add(lbl);
        }
        this.doLayout();
    }

    public Icon getDisabledIcon() {
        return this._lblIcon.getDisabledIcon();
    }

    public int getDisplayedMnemonic() {
        return this._texts.get(0).getDisplayedMnemonic();
    }

    public int getDisplayedMnemonicIndex() {
        return this._texts.get(0).getDisplayedMnemonicIndex();
    }

    public int getHorizontalAlignment() {
        return this._texts.get(0).getHorizontalAlignment();
    }

    public Icon getIcon() {
        return this._lblIcon.getIcon();
    }

    public String getText() {
        StringBuffer sb = new StringBuffer(this._texts.size() * 40);
        int size = this._texts.size();
        for (int i = 0; i < size; ++i) {
            sb.append(this._texts.get(i).getText());
            if (i >= size - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getVerticalAlignment() {
        return this._texts.get(0).getVerticalAlignment();
    }

    public void setDisabledIcon(Icon disabledIcon) {
        this._lblIcon.setDisabledIcon(disabledIcon);
    }

    public void setIcon(Icon icon) {
        this._lblIcon.setIcon(icon);
    }

    public void setDisplayedMnemonic(char aChar) {
        this._texts.get(0).setDisplayedMnemonic(aChar);
    }

    public void setDisplayedMnemonic(int key) {
        this._texts.get(0).setDisplayedMnemonic(key);
    }

    public void setDisplayedMnemonicIndex(int index) throws IllegalArgumentException {
        this._texts.get(0).setDisplayedMnemonicIndex(index);
    }

    public void setHorizontalAlignment(int alignment) {
        int size = this._texts.size();
        for (int i = 0; i < size; ++i) {
            JLabel lbl = this._texts.get(i);
            lbl.setHorizontalAlignment(alignment);
        }
        this._lblIcon.setHorizontalAlignment(alignment);
        int layoutAlignement = 0;
        if (alignment == 0) {
            layoutAlignement = 1;
        } else if (alignment == 4) {
            layoutAlignement = 2;
        }
        if (this._layout.getAlignment() != layoutAlignement) {
            this._layout.setAlignment(layoutAlignement);
            this.doLayout();
        }
    }

    public void setVerticalAlignment(int alignment) {
        int size = this._texts.size();
        for (int i = 0; i < size; ++i) {
            JLabel lbl = this._texts.get(i);
            lbl.setVerticalAlignment(alignment);
        }
        this._lblIcon.setVerticalAlignment(alignment);
    }

    @Override
    public void setVisible(boolean visible) {
        int size = this._texts.size();
        for (int i = 0; i < size; ++i) {
            this._texts.get(i).setVisible(visible);
        }
        this._lblIcon.setVisible(visible);
    }

    @Override
    public boolean isVisible() {
        return this._lblIcon.isVisible();
    }

    @Override
    public void setEnabled(boolean aflag) {
        int size = this._texts.size();
        for (int i = 0; i < size; ++i) {
            this._texts.get(i).setEnabled(aflag);
        }
        this._lblIcon.setEnabled(aflag);
    }

    @Override
    public boolean isEnabled() {
        return this._lblIcon.isEnabled();
    }
}

