/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.other;

import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class LimitedTableCellRenderer
extends DefaultTableCellRenderer {
    int _nbrLine;

    public LimitedTableCellRenderer() {
        this(5);
    }

    public LimitedTableCellRenderer(int nbrLine) {
        this._nbrLine = nbrLine;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Object text = null;
        StringBuilder sb = new StringBuilder();
        String strValue = value.toString().trim();
        if (strValue.isEmpty()) {
            this.setText("");
            this.setToolTipText(null);
        } else {
            StringTokenizer st = new StringTokenizer(strValue, "\n");
            sb.append("<html>");
            int i = 0;
            while (st.hasMoreTokens()) {
                if (i > 0) {
                    sb.append("<br/>");
                }
                if (i == this._nbrLine) {
                    text = sb.toString() + "...</html>";
                }
                sb.append(st.nextToken());
                ++i;
            }
            sb.append("</html>");
            if (text == null) {
                text = sb.toString();
            }
            this.setText((String)text);
        }
        return this;
    }
}

