/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.other;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.image.BufferedImage;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;

public class PartialCheckBox
extends JCheckBox
implements ActionListener {
    boolean _bFirstUpdate = false;
    private static Icon __iconPartial = null;
    private static Color _alphaGrey = new Color(128, 128, 128, 128);

    public PartialCheckBox(String text, Icon icon) {
        super(text, icon);
    }

    public PartialCheckBox(String text) {
        this(text, null);
    }

    public PartialCheckBox() {
        this((String)null);
    }

    public PartialCheckBox setAsymetricChangeValue(boolean asymetric) {
        if (this.model instanceof PartialButtonModel) {
            ((PartialButtonModel)this.model).setAsymetricChangeValue(asymetric);
        }
        return this;
    }

    public boolean isAsymetricChangeValue() {
        if (this.model instanceof PartialButtonModel) {
            return ((PartialButtonModel)this.model).isAsymetricChangeValue();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected void init(String text, Icon icon) {
        this.model = new PartialButtonModel();
        this.setModel(this.model);
        this.addActionListener(this);
        super.init(text, icon);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.isPartial()) {
            this.adjustPartialIcon();
        } else {
            this.restorePartialIcon();
        }
        this._bFirstUpdate = true;
    }

    private static synchronized void constructIconPartial() {
        if (__iconPartial != null) {
            return;
        }
        Icon defIcon = UIManager.getIcon("CheckBox.icon");
        __iconPartial = new PartialIcon(defIcon);
    }

    protected void adjustPartialIcon() {
        if (__iconPartial == null) {
            PartialCheckBox.constructIconPartial();
        }
        this.setIcon(__iconPartial);
    }

    protected void restorePartialIcon() {
        this.setIcon(null);
    }

    public boolean isPartial() {
        return this.getState() == State.PARTIAL;
    }

    public void setPartial(boolean partial) {
        if (partial) {
            this.setState(State.PARTIAL);
            if (!this._bFirstUpdate) {
                this.updateUI();
            }
        } else {
            this.setState(State.FALSE);
        }
    }

    public State getState() {
        if (this.model instanceof PartialButtonModel && ((PartialButtonModel)this.model).isPartial()) {
            return State.PARTIAL;
        }
        if (this.model.isSelected()) {
            return State.TRUE;
        }
        return State.FALSE;
    }

    public void setState(State state) {
        switch (state) {
            case PARTIAL: {
                if (this.model instanceof PartialButtonModel) {
                    if (!((PartialButtonModel)this.model).isPartial()) {
                        ((PartialButtonModel)this.model).setPartial(true);
                    }
                    if (this._bFirstUpdate) break;
                    this.updateUI();
                    break;
                }
            }
            case FALSE: {
                this.model.setSelected(false);
                break;
            }
            case TRUE: {
                this.model.setSelected(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stateUpdated(this.getState());
    }

    protected void stateUpdated(State state) {
        if (state == State.PARTIAL) {
            this.adjustPartialIcon();
        } else {
            this.restorePartialIcon();
        }
    }

    public static void main(String[] args) {
        JDialog win = new JDialog();
        win.setModal(true);
        win.setTitle("test de partial check box");
        win.getContentPane().setLayout(new BorderLayout());
        PartialCheckBox cb = new PartialCheckBox("Partial check box");
        cb.setAsymetricChangeValue(true);
        cb.setPartial(true);
        win.getContentPane().add((Component)cb, "Center");
        win.pack();
        win.setDefaultCloseOperation(2);
        win.setLocationRelativeTo(null);
        win.setVisible(true);
    }

    static class PartialButtonModel
    extends JToggleButton.ToggleButtonModel {
        public static final int PARTIAL = 128;
        boolean _bAsymetricChangeValue = false;

        public void setAsymetricChangeValue(boolean asymetric) {
            this._bAsymetricChangeValue = asymetric;
        }

        public boolean isAsymetricChangeValue() {
            return this._bAsymetricChangeValue;
        }

        @Override
        public void setPressed(boolean pressed) {
            if (this.isPressed() == pressed || !this.isEnabled()) {
                return;
            }
            if (!pressed && this.isArmed()) {
                this.changeState();
            }
            this.stateMask = pressed ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!this.isPressed() && this.isArmed()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiersEx();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
        }

        protected void changeState() {
            State state = State.FALSE;
            if (this.isPartial()) {
                state = State.PARTIAL;
            } else if (this.isSelected()) {
                state = State.TRUE;
            }
            switch (state) {
                case PARTIAL: {
                    state = State.TRUE;
                    break;
                }
                case TRUE: {
                    state = State.FALSE;
                    break;
                }
                case FALSE: {
                    state = this._bAsymetricChangeValue ? State.TRUE : State.PARTIAL;
                }
            }
            switch (state) {
                case PARTIAL: {
                    this.setPartial(true);
                    break;
                }
                case TRUE: {
                    this.setSelected(true);
                    break;
                }
                case FALSE: {
                    this.setSelected(false);
                }
            }
        }

        @Override
        public void setSelected(boolean selected) {
            boolean partial = this.isPartial();
            if (partial) {
                this.stateMask &= 0xFFFFFF7F;
                this.stateMask = !this.isSelected() ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
            }
            super.setSelected(selected);
        }

        public boolean isPartial() {
            return (this.stateMask & 0x80) != 0;
        }

        public void setPartial(boolean partial) {
            if (this.isPartial() == partial) {
                return;
            }
            if (partial) {
                this.stateMask |= 0x80;
                this.stateMask |= 2;
            } else {
                this.stateMask &= 0xFFFFFF7F;
            }
            this.fireStateChanged();
        }
    }

    static class PartialIcon
    implements Icon {
        Icon _delegateIcon;

        PartialIcon(Icon delegateIcon) {
            this._delegateIcon = delegateIcon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            BufferedImage buffer = new BufferedImage(width, height, 10);
            Graphics2D g2D = (Graphics2D)buffer.getGraphics();
            this._delegateIcon.paintIcon(c, g2D, 0, 0);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2D.setColor(_alphaGrey);
            g2D.fillRect(0, 0, width, height);
            g2D.dispose();
            g.drawImage(buffer, x, y, width, height, null);
        }

        @Override
        public int getIconWidth() {
            return this._delegateIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this._delegateIcon.getIconHeight();
        }
    }

    public static enum State {
        TRUE,
        FALSE,
        PARTIAL;

    }

    public static class TableEditor
    extends DefaultCellEditor {
        PartialCheckBox _editor = (PartialCheckBox)this.getComponent();

        public TableEditor() {
            super(new PartialCheckBox());
            this._editor.setHorizontalAlignment(0);
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object newValue) {
                    if (newValue instanceof State) {
                        _editor.setState((State)((Object)newValue));
                    } else {
                        boolean selected = false;
                        if (newValue instanceof Boolean) {
                            selected = (Boolean)newValue;
                        } else if (newValue instanceof String) {
                            selected = newValue.equals("true");
                        }
                        _editor.setSelected(selected);
                    }
                }

                @Override
                public Object getCellEditorValue() {
                    return _editor.getState();
                }
            };
            this._editor.addActionListener(this.delegate);
            this._editor.setRequestFocusEnabled(false);
        }
    }

    public static class TableRenderer
    extends PartialCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public TableRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setState(value == null ? State.FALSE : (State)((Object)value));
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }
}

