/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.other;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class PrintPreviewCanvas
extends JPanel {
    private static Logger _LOG = Logger.getLogger(PrintPreviewCanvas.class.getPackage().getName());
    Pageable _book;
    int _currentPage;
    double _zoom = 1.0;

    public PrintPreviewCanvas(Pageable book) {
        this._book = book;
        this._currentPage = 0;
    }

    public void setZoom(double zoom) {
        this._zoom = zoom;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        PageFormat pg = this.getPageFormat();
        double px = pg.getWidth();
        double py = pg.getHeight();
        int dx = this.getWidth() - (int)(px * this._zoom);
        int dy = this.getHeight() - (int)(py * this._zoom);
        if (dx < 0) {
            dx = 0;
        }
        if (dy < 0) {
            dy = 0;
        }
        g2.translate(dx / 2, dy / 2);
        g2.scale(this._zoom, this._zoom);
        Rectangle2D.Double page = new Rectangle2D.Double(0.0, 0.0, px, py);
        g2.setPaint(Color.white);
        g2.fill(page);
        g2.setPaint(Color.black);
        g2.draw(page);
        Printable printable = this._book.getPrintable(this._currentPage);
        try {
            printable.print(g2, pg, this._currentPage);
        }
        catch (PrinterException pe) {
            _LOG.log(Level.WARNING, "Probleme lors de l'impression de la page : " + this._currentPage, pe);
            _LOG.log(Level.INFO, pe.getMessage());
            _LOG.log(Level.FINEST, "Exception generee : ", pe);
            g2.setPaint(Color.red);
            g2.draw(new Line2D.Double(0.0, 0.0, px, py));
            g2.draw(new Line2D.Double(0.0, py, px, 0.0));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        double h;
        double w;
        PageFormat pg = this.getPageFormat();
        if (pg == null) {
            pg = PrinterJob.getPrinterJob().defaultPage();
        }
        if (this._zoom == 1.0) {
            w = pg.getWidth();
            h = pg.getHeight();
        } else {
            w = (int)(pg.getWidth() * this._zoom) + 1;
            h = (int)(pg.getHeight() * this._zoom) + 1;
        }
        return new Dimension((int)w + 20, (int)h + 20);
    }

    public PageFormat getPageFormat() {
        return this._book.getPageFormat(this._currentPage);
    }

    public final void setBook(Pageable book) {
        this._book = book;
        this.changeCurrentPage(0);
    }

    public void changeCurrentPage(int newPg) {
        if (newPg == this._currentPage) {
            return;
        }
        if (newPg < 0 || newPg >= this._book.getNumberOfPages()) {
            throw new IllegalArgumentException();
        }
        this._currentPage = newPg;
        this.repaint();
    }
}

