/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class ArrayTableModel<P>
extends AbstractTableModel {
    ArrayList<P> _array;
    protected boolean _editable = true;

    public ArrayTableModel() {
        this._array = new ArrayList();
    }

    public ArrayTableModel(ArrayList<P> array) {
        this._array = array;
    }

    public List getData() {
        return this._array;
    }

    public void setData(List<P> data) {
        this._array = new ArrayList<P>(data);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this._array.size();
    }

    public P getItemAt(int rowIndex) {
        return this._array.get(rowIndex);
    }

    public void setEditable(boolean b) {
        this._editable = b;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return this._editable;
    }

    public void addData(P obj) {
        int idx = this._array.size();
        this._array.add(obj);
        this.fireTableRowsInserted(idx, idx);
    }

    public void insertData(P obj, int idx) {
        this._array.add(idx, obj);
        this.fireTableRowsInserted(idx, idx);
    }

    public void removeData(P obj) {
        int idx = this._array.indexOf(obj);
        if (idx >= 0) {
            this.removeData(idx);
        }
    }

    public void removeData(int idx) {
        this.fireTableRowsDeleted(idx, idx);
        this._array.remove(idx);
    }

    public void changeData(P obj) {
        int idx = this._array.indexOf(obj);
        if (idx >= 0) {
            this.fireTableRowsUpdated(idx, idx);
        }
    }

    public void down(int idx) {
        assert (idx > 0 && idx <= this._array.size() - 1) : Integer.toString(idx);
        P obj = this._array.remove(idx);
        this._array.add(idx - 1, obj);
        this.fireTableRowsUpdated(idx - 1, idx);
    }

    public void down(int[] indices) {
        int first = indices[0];
        int last = indices[indices.length - 1];
        if (indices[indices.length - 1] != this._array.size() - 1) {
            P port = this._array.remove(indices[indices.length - 1]);
            this._array.add(indices[indices.length - 1] + 1, port);
            indices[indices.length - 1] = indices[indices.length - 1] + 1;
            ++last;
        }
        for (int i = indices.length - 2; i >= 0; --i) {
            if (indices[i] + 1 == indices[i + 1]) continue;
            P port = this._array.remove(indices[i]);
            this._array.add(indices[i] + 1, port);
            indices[i] = indices[i] + 1;
        }
        this.fireTableRowsUpdated(first, last);
    }

    public void up(int idx) {
        assert (idx >= 0 && idx < this._array.size() - 1) : Integer.toString(idx);
        P obj = this._array.remove(idx);
        this._array.add(idx + 1, obj);
        this.fireTableRowsUpdated(idx, idx + 1);
    }

    public void up(int[] indices) {
        int first = indices[0];
        int last = indices[indices.length - 1];
        if (indices[0] != 0) {
            P obj = this._array.remove(indices[0]);
            this._array.add(indices[0] - 1, obj);
            indices[0] = indices[0] - 1;
            --first;
        }
        for (int i = 1; i < indices.length; ++i) {
            if (indices[i] - 1 == indices[i - 1]) continue;
            P obj = this._array.remove(indices[i]);
            this._array.add(indices[i] - 1, obj);
            indices[i] = indices[i] - 1;
        }
        this.fireTableRowsUpdated(first, last);
    }
}

