/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.table;

import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class CeciliaTable
extends JTable {
    public CeciliaTable(TableModel model) {
        super(model);
        this.init();
    }

    public CeciliaTable() {
        this.init();
        this.setTransferHandler(new JTableTransfertHandler());
    }

    private void init() {
        this.setInheritsPopupMenu(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int idx;
                if (SwingUtilities.isRightMouseButton(e) && !CeciliaTable.this.isRowSelected(idx = CeciliaTable.this.rowAtPoint(new Point(e.getX(), e.getY())))) {
                    CeciliaTable.this.setRowSelectionInterval(idx, idx);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                CeciliaTable.this.doubleClickLeft(e);
            }
        });
        this.initSorter();
    }

    protected void doubleClickLeft(MouseEvent e) {
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model);
        if (this.withSorter() && this.getRowSorter() != null) {
            ((TableRowSorter)this.getRowSorter()).setModel(model);
            this.updateSorter();
        }
    }

    private void initSorter() {
        if (!this.withSorter()) {
            return;
        }
        this.setRowSorter(new TableRowSorter<TableModel>(this.getModel()));
        this.updateSorter();
    }

    protected boolean withSorter() {
        return false;
    }

    protected List<Integer> getUnsortableCols() {
        return null;
    }

    public void updateSorter() {
        TableRowSorter sorter = (TableRowSorter)this.getRowSorter();
        List<Integer> unsortableColsIdx = this.getUnsortableCols();
        if (unsortableColsIdx != null) {
            for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
                sorter.setSortable(i, !unsortableColsIdx.contains(i));
            }
        }
        sorter.toggleSortOrder(0);
    }
}

