/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.table;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.table.ItemsTableModel;
import com.dassault.cecilia.core.swing.table.TablePanel;
import com.dassault.cecilia.dbobj.ResMsgObj;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class ItemsTablePanel<P>
extends TablePanel
implements ChangeListener {
    protected ItemsTableModel<P> _tableModel;
    List<ChangeListener> _listeners = new ArrayList<ChangeListener>();
    ChangeEvent _chgEvent = null;
    protected CeciliaAction _ctrlRefresh;

    public ItemsTablePanel(Window window, ItemsTableModel<P> model, boolean bInit) {
        super(window, model, bInit);
        this._tableModel = model;
    }

    public void addChangeListener(ChangeListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this._listeners.remove(listener);
    }

    protected void fireChangeState() {
        if (this._chgEvent == null) {
            this._chgEvent = new ChangeEvent(this);
        }
        for (ChangeListener listener : this._listeners) {
            listener.stateChanged(this._chgEvent);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refresh();
    }

    protected abstract Collection<P> findAll();

    public void refresh() {
        Collection<P> refreshData = this.findAll();
        if (refreshData == null) {
            return;
        }
        ArrayList<P> selectedItems = new ArrayList<P>();
        int[] row = this._ctrlTable.getSelectedRows();
        for (int i = 0; i < row.length; ++i) {
            selectedItems.add(this._tableModel.getItem(row[i]));
        }
        ArrayList<P> currentItems = new ArrayList<P>(refreshData);
        ListSelectionModel select = this._ctrlTable.getSelectionModel();
        this._tableModel.setItems(currentItems);
        for (Object item : selectedItems) {
            int idx = currentItems.indexOf(item);
            if (idx == -1) continue;
            select.addSelectionInterval(idx, idx);
        }
    }

    @Override
    protected void initialise() {
        this._ctrlRefresh = new CeciliaAction(ResIcoCore.getImageIcon("BUT_REFRESH"), ResMsgVoc.getString("VOC_REFRESH"), ResMsgObj.getString("ACTION_REFRESH_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemsTablePanel.this.refresh();
            }
        };
        super.initialise();
    }
}

