/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.table;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class StringMapTableModel
extends AbstractTableModel {
    protected ArrayList<String> _keys = new ArrayList();
    protected ArrayList<String> _vals = new ArrayList();
    boolean _editable = true;

    public Map<String, String> getData() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < this._keys.size(); ++i) {
            if (this._keys.get(i).trim().length() <= 0) continue;
            result.put(this._keys.get(i), this._vals.get(i));
        }
        return result;
    }

    public List<String> getKeys() {
        return this._keys;
    }

    public List<String> getValues() {
        return this._vals;
    }

    public void setData(Map<String, String> data) {
        this._keys = new ArrayList();
        this._vals = new ArrayList();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            this._keys.add(entry.getKey());
            this._vals.add(entry.getValue());
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this._keys.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this._keys.get(rowIndex);
        }
        return this._vals.get(rowIndex);
    }

    @Override
    public void setValueAt(Object item, int r, int c) {
        assert (item instanceof String);
        if (c == 0) {
            this._keys.set(r, item.toString());
        } else {
            this._vals.set(r, item.toString());
        }
        this.fireTableRowsUpdated(r, r);
    }

    public void setEditable(boolean b) {
        this._editable = b;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return this._editable;
    }

    public void addData(String key, String val) {
        int idx = this._keys.size();
        this._keys.add(key);
        this._vals.add(val);
        this.fireTableRowsInserted(idx, idx);
    }

    public void insertData(String key, String val, int idx) {
        this._keys.add(idx, key);
        this._vals.add(idx, val);
        this.fireTableRowsInserted(idx, idx);
    }

    public void removeData(String key) {
        int idx = this._keys.indexOf(key);
        if (idx >= 0) {
            this.removeData(idx);
        }
    }

    public void removeData(int idx) {
        this.fireTableRowsDeleted(idx, idx);
        this._keys.remove(idx);
        this._vals.remove(idx);
    }

    public void down(int idx) {
        assert (idx > 0 && idx <= this._keys.size() - 1) : Integer.toString(idx);
        String key = this._keys.remove(idx);
        this._keys.add(idx - 1, key);
        String val = this._vals.remove(idx);
        this._vals.add(idx - 1, val);
        this.fireTableRowsUpdated(idx - 1, idx);
    }

    public void up(int idx) {
        assert (idx >= 0 && idx < this._keys.size() - 1) : Integer.toString(idx);
        String key = this._keys.remove(idx);
        this._keys.add(idx + 1, key);
        String val = this._vals.remove(idx);
        this._vals.add(idx + 1, val);
        this.fireTableRowsUpdated(idx, idx + 1);
    }
}

