/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.tree;

import com.dassault.cecilia.core.swing.tree.AbstractTreeTableModel;
import com.dassault.cecilia.core.swing.tree.TreeTable;
import java.io.File;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TestJTreeTable {
    private JFrame _mainFrame;
    private TreeTable _treeTable;
    private TreeTable.TreeTableModel<File> _treeTableModel;

    public TestJTreeTable() {
        this.initGui();
    }

    private void initGui() {
        this._mainFrame = new JFrame(TreeTable.class.getName());
        this._mainFrame.setSize(800, 600);
        this._mainFrame.setDefaultCloseOperation(2);
        this._treeTableModel = new FileTTModel(new File("/"));
        this._treeTable = new TreeTable(this._treeTableModel);
        DefaultTreeCellRenderer treeRenderer = new DefaultTreeCellRenderer();
        this._treeTable.getTree().setCellRenderer(treeRenderer);
        this._treeTable.getTree().putClientProperty("JTree.lineStyle", "None");
        this._mainFrame.getContentPane().add(new JScrollPane(this._treeTable));
    }

    public static void main(String[] args) {
        TestJTreeTable tester = new TestJTreeTable();
        tester._mainFrame.setVisible(true);
    }

    private class FileTTModel
    extends AbstractTreeTableModel<File> {
        private String[] columnNames;
        private static final int NAME_COLUMN = 0;
        private static final int SIZE_COLUMN = 1;
        private static final int DATE_COLUMN = 2;

        public FileTTModel(File root) {
            super(root);
            this.columnNames = new String[]{"NAME", "SIZE", "DATE"};
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof File) {
                File parentFile = (File)parent;
                if (parentFile.isDirectory()) {
                    File[] children = parentFile.listFiles();
                    if (children != null && children.length > index) {
                        return children[index];
                    }
                    return null;
                }
                throw new RuntimeException("Not a directory!");
            }
            throw new RuntimeException("Not a file!");
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof File) {
                File parentFile = (File)parent;
                if (parentFile.isDirectory()) {
                    File[] children = parentFile.listFiles();
                    return children == null ? 0 : children.length;
                }
                return 0;
            }
            throw new RuntimeException("Not a file!");
        }

        @Override
        public Class getColumnClass(int column) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Object getValueAt(File node, int row, int column) {
            switch (column) {
                case 0: {
                    return node.getName();
                }
                case 1: {
                    return node.length();
                }
                case 2: {
                    return new Date(node.lastModified()).toString();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(File node, int row, int column) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, File node, int row, int column) {
        }
    }
}

