/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.taskmanager;

import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.taskmanager.ProgressPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ModalProgressPanel
extends ProgressPanel {
    protected boolean _started = false;
    protected Animator _animation = null;
    protected PlugTask _task = null;
    protected int _alphaLevel = 0;
    protected JLabel _ctrlIcone;
    protected JLabel _ctrlMsg;

    public ModalProgressPanel() {
        this.setLayout(new GridBagLayout());
        this._ctrlIcone = new JLabel(new ImageIcon(this.getClass().getResource("wait_anim.gif")));
        this._ctrlMsg = new JLabel("Messag", 0);
        this.add((Component)this._ctrlIcone, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._ctrlMsg, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public void start(PlugTask task) {
        this._ctrlMsg.setText("   ");
        this.doLayout();
        this.addMouseListener(this);
        this.setVisible(true);
        this._task = task;
        this._alphaLevel = 150;
        this._animation = new Animator();
        this._animation.start();
    }

    @Override
    public void stop() {
        this.removeMouseListener(this);
        this._animation.requestStop();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this._started) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(new Color(255, 255, 255, this._alphaLevel));
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
        }
    }

    protected class Animator
    extends Thread {
        protected boolean _reqStop;

        protected Animator() {
            super("Cecilia-StartWait");
            this._reqStop = false;
        }

        protected void requestStop() {
            this._reqStop = true;
        }

        @Override
        public void run() {
            ModalProgressPanel.this._started = true;
            ModalProgressPanel.this.repaint();
            while (!Animator.interrupted() && !this._reqStop) {
                try {
                    Animator.sleep(1000L);
                    if (ModalProgressPanel.this._task == null) continue;
                    String msg = ModalProgressPanel.this._task.getInfo("process.msg");
                    if (msg == null) {
                        msg = "";
                    }
                    ModalProgressPanel.this._ctrlMsg.setText(msg);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            ModalProgressPanel.this._started = false;
            ModalProgressPanel.this._animation = null;
            ModalProgressPanel.this._alphaLevel = 0;
            ModalProgressPanel.this.repaint();
            ModalProgressPanel.this.setVisible(false);
        }
    }
}

