/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.taskmanager;

import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.taskmanager.InfiniteProgressPanel;
import com.dassault.cecilia.core.taskmanager.ModalProgressPanel;
import com.dassault.cecilia.core.taskmanager.NullProgressPanel;
import com.dassault.cecilia.core.taskmanager.ProgressPanel;
import com.dassault.cecilia.core.taskmanager.ResTask;
import com.dassault.cecilia.core.taskmanager.TaskList;
import com.dassault.cecilia.core.taskmanager.TaskState;
import com.dassault.cecilia.core.taskmanager.TaskThread;
import com.dassault.cecilia.core.taskmanager.TasksPanel;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class TaskMng {
    public static final String PROP_TASKMANAGER_PROGRESS_DEF = "StdProgress";
    public static final String PROP_TASKMANAGER_PROGRESS = "cecilia.gui.progress";
    Plugable _launcher;
    JFrame _frame;
    ProgressPanel _glassPane;
    TaskList _normTasks;
    List<TaskThread> _highTasks;
    Runnable _stopAnim = new Runnable(){

        @Override
        public void run() {
            TaskMng.this._glassPane.stop();
        }
    };
    private static final boolean __TRACE = false;

    public TaskMng(Plugable launcher) {
        this._launcher = launcher;
        if (launcher.getWindow() instanceof JFrame) {
            this._frame = (JFrame)launcher.getWindow();
            String progress = System.getProperty(PROP_TASKMANAGER_PROGRESS, PROP_TASKMANAGER_PROGRESS_DEF);
            this._glassPane = progress.equalsIgnoreCase("InfiniteProgress") ? new InfiniteProgressPanel("", 12, 0.7f, 5.0f, 1000) : (progress.equalsIgnoreCase("GIFProgress") ? new ModalProgressPanel() : (progress.equalsIgnoreCase("NullProgress") ? new NullProgressPanel() : new InfiniteProgressPanel("", 12, 0.7f, 5.0f, 0)));
            this._frame.setGlassPane(this._glassPane);
        }
        this._normTasks = new TaskList();
        this._highTasks = Collections.synchronizedList(new LinkedList());
        ManagerThread mng = new ManagerThread();
        mng.setPriority(7);
        mng.start();
    }

    public void addTask(PlugTask task, long uid) {
        if (task.isPriority()) {
            HighTask tt = new HighTask(task, uid);
            tt.setPriority(6);
            this._highTasks.add(tt);
        } else {
            TaskThread tt = new TaskThread(task, uid);
            tt.setPriority(3);
            this._normTasks.add(tt);
        }
    }

    public List<TaskThread> getTasks(long uid) {
        return this._normTasks.getTasks(uid);
    }

    public PlugPanel requestDisplay() {
        return new TasksPanel(this._normTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestExit(boolean forceClose) {
        boolean active = false;
        TaskList taskList = this._normTasks;
        synchronized (taskList) {
            for (int i = this._normTasks.getRowCount() - 1; i >= 0 && !active; --i) {
                if (this._normTasks.get(i).state() == TaskState.FINISH) continue;
                active = true;
            }
        }
        if (active) {
            if (!forceClose) {
                return JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this._launcher.getWindow()), ResTask.getString("MSG_WARNING_EXIT"), ResTask.getString("PAN_TASK_TITLE"), 0) == 0;
            }
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._launcher.getWindow()), ResTask.getString("MSG_WARNING_EXIT"), ResTask.getString("PAN_TASK_TITLE"), 1);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceExit() {
        TaskList taskList = this._normTasks;
        synchronized (taskList) {
            boolean waitStop = false;
            block8: for (int i = this._normTasks.getRowCount() - 1; i >= 0; --i) {
                TaskThread task = this._normTasks.get(i);
                switch (task.state()) {
                    case FINISH: 
                    case STOPPED: {
                        continue block8;
                    }
                    default: {
                        task.requestStop();
                        waitStop = true;
                    }
                }
            }
            if (waitStop) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected void trace(String msg) {
    }

    public void refreshTask(TaskThread taskThread) {
        this._normTasks.refresh(taskThread);
    }

    class ManagerThread
    extends Thread {
        private TaskThread _curTask;
        boolean _lockNorm;

        public ManagerThread() {
            super("Cecilia-TaskManager");
            this._curTask = null;
            this._lockNorm = false;
            this.setDaemon(true);
        }

        private void setCurrentTask(TaskThread curTask) {
            if (this._curTask == curTask) {
                return;
            }
            this._curTask = curTask;
            if (this._curTask != null) {
                TaskMng.this._normTasks.select(curTask);
            }
        }

        @Override
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    ManagerThread.sleep(100L);
                    if (this._curTask != null && this._curTask.state() == TaskState.FINISH) {
                        if (this._curTask.getTask().isPriority()) {
                            TaskMng.this._highTasks.remove(this._curTask);
                        } else {
                            TaskMng.this._normTasks.refresh(this._curTask);
                        }
                        this.setCurrentTask(null);
                    }
                    if (TaskMng.this._highTasks.size() > 0) {
                        if (!this._lockNorm) {
                            TaskMng.this.trace("TaskMng : LockNorm");
                            if (this._curTask != null && !this._curTask.getTask().isPriority()) {
                                this._curTask.requestSuspend(true);
                            }
                            this.setCurrentTask(null);
                            this._lockNorm = true;
                        }
                        if (this._curTask != null) continue;
                        this.setCurrentTask(TaskMng.this._highTasks.get(0));
                        if (this._curTask.state() != TaskState.INIT) continue;
                        this._curTask.start();
                        continue;
                    }
                    if (this._curTask != null && this._curTask.state() != TaskState.RUN) {
                        this.setCurrentTask(null);
                    }
                    if (this._curTask == null) {
                        this.setCurrentTask(TaskMng.this._normTasks.next());
                        if (this._curTask != null) {
                            if (this._curTask.state() == TaskState.INIT) {
                                TaskMng.this.trace("TaskMng Start : " + this._curTask.getTask().getInfo("plugin.name"));
                                this._curTask.start();
                            } else if (this._curTask.state() == TaskState.HPAUSE) {
                                TaskMng.this.trace("TaskMng Resume : " + this._curTask.getTask().getInfo("plugin.name"));
                                this._curTask.requestResume(true);
                            }
                        }
                    }
                    TaskMng.this._normTasks.refresh(this._curTask);
                    this._lockNorm = false;
                    ArrayList<TaskThread> refreshPauseTask = new ArrayList<TaskThread>();
                    for (TaskThread task : TaskMng.this._normTasks._tasks) {
                        if (task == this._curTask) continue;
                        refreshPauseTask.add(task);
                    }
                    for (int i = 0; i < refreshPauseTask.size(); ++i) {
                        TaskMng.this._normTasks.refresh((TaskThread)refreshPauseTask.get(i));
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class HighTask
    extends TaskThread {
        HighTask(PlugTask action, long uid) {
            super(action, uid);
        }

        @Override
        public void run() {
            if (TaskMng.this._glassPane != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TaskMng.this._glassPane.start(HighTask.this.getTask());
                    }
                });
            }
            super.run();
            if (TaskMng.this._glassPane != null) {
                EventQueue.invokeLater(TaskMng.this._stopAnim);
            }
        }
    }
}

