/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.client;

import com.dassault.cecilia.crc.client.Computation;
import com.dassault.cecilia.crc.client.historical.HistoricalRequestTableModel;
import com.dassault.cecilia.crc.common.CRCClientException;
import com.dassault.cecilia.crc.common.CRCEngineType;
import com.dassault.cecilia.crc.common.CRCException;
import com.dassault.cecilia.crc.common.ComputationRequestStatus;
import com.dassault.cecilia.crc.common.io.IOFilesExchange;
import com.dassault.cecilia.crc.common.io.IOFilesExchangeHTTP;
import com.dassault.cecilia.crc.common.io.IOFilesExchangeSFTP;
import com.dassault.cecilia.crc.common.pojo.InitComputationResponse;
import com.dassault.cecilia.crc.common.pojo.InitLaunchMelComputationChildsRequest;
import com.dassault.cecilia.crc.common.pojo.InitLaunchMelComputationChildsResponse;
import com.dassault.cecilia.crc.common.pojo.LaunchComputationRequest;
import com.dassault.cecilia.crc.common.pojo.ManagerInfos;
import com.dassault.cecilia.crc.common.pojo.SftpInfosResponse;
import com.dassault.cecilia.crc.common.pojo.SftpProperties;
import com.dassault.cecilia.crc.common.template.RestTemplateConfig;
import com.dassault.cecilia.crc.common.template.RestTemplateUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class CRCSchedulerUtil {
    private static final String SSH_KEY_FILENAME = "/.ssh/id_rsa";
    private static String currentSchedulerUrl = null;
    private static boolean bPrincipalScheduler = true;
    private static RestTemplate _restTemplate;
    private static RestTemplateConfig _restTemplateConfig;
    private static IOFilesExchange _ioFilesExchange;
    private static boolean _bCallInitLaunch;
    private static Logger _logger;
    public static final String PROP_DEFINE_CERTIFICAT_PATH = "cecilia.core.ssl.cert.method1Path";
    public static final String PROP_DEFINE_CERTIFICAT_PWD = "cecilia.core.ssl.cert.method1Pwd";
    public static final String PROP_SSL_CERTIFICATE_PATH = "cecilia.core.ssl.cert.method2Path";
    public static final String PROP_SSL_CERTIFICATE_PWD = "cecilia.core.ssl.cert.method2Pwd";
    public static final String DEFAULT_FOLDER_SSL_CERTIFICATE = "./core/certificates";
    public static final String PROP_FOLDER_SSL_CERTIFICATE = "cecilia.core.ssl.cert.method3Folder";
    public static final String PROP_DEFINE_CONNECT_MAIN = "cecilia.remote.computation.scheduler.url.base";
    public static final String PROP_DEFINE_CONNECT_SECONDARY = "cecilia.remote.computation.scheduler.url.base.secours";
    public static final String PROP_DEFINE_INDICATOR_REFRESH = "cecilia.remote.computation.indicator.refresh";
    public static final String PROP_DEFINE_TIMEOUT = "cecilia.remote.computation.scheduler.timeout";
    public static final String PROP_DEFINE_STATUS_NBRERROR = "cecilia.remote.computation.scheduler.status.nbrError";
    public static final String PROP_DEFINE_RESULT_NBRERROR = "cecilia.remote.computation.scheduler.result.nbrError";
    public static final String PROP_DEFINE_RESULT_DELAY = "cecilia.remote.computation.scheduler.result.delayIfError";
    public static final String PROP_DEFINE_SSH_KEY_MODE = "cecilia.remote.computation.scheduler.ssh.key";
    public static final String PROP_DEFINE_SSH_IDENTITY = "cecilia.remote.computation.scheduler.ssh.identityFile";
    public static final String PROP_DEFINE_SSH_USER = "cecilia.remote.computation.scheduler.ssh.user";
    private static final String __MinSchedulerVersion = "2.0.0";
    private static Pattern __PatternVersion;
    static HistoricalRequestTableModel _requestsModel;

    public static String getUrlSchedulerBase() {
        if (currentSchedulerUrl == null) {
            currentSchedulerUrl = System.getProperty(PROP_DEFINE_CONNECT_MAIN) + "/crcscheduler";
            bPrincipalScheduler = true;
        }
        return currentSchedulerUrl;
    }

    private static synchronized boolean switchAnotherScheduler() {
        if (bPrincipalScheduler) {
            String prop = System.getProperty(PROP_DEFINE_CONNECT_SECONDARY);
            if (prop == null) {
                return false;
            }
            currentSchedulerUrl = prop + "/crcscheduler";
            bPrincipalScheduler = false;
        } else {
            currentSchedulerUrl = System.getProperty(PROP_DEFINE_CONNECT_MAIN) + "/crcscheduler";
            bPrincipalScheduler = true;
        }
        return true;
    }

    public static int getMaxMemory(boolean switchIfNeeded) throws CRCException {
        try {
            return (Integer)RestTemplateUtil.getForEntity((RestTemplate)CRCSchedulerUtil.createOrGetRestTemplate(), (String)(CRCSchedulerUtil.getUrlSchedulerBase() + "/maxMemory"), Integer.class);
        }
        catch (CRCException e) {
            if (switchIfNeeded && CRCSchedulerUtil.switchAnotherScheduler()) {
                try {
                    return (Integer)RestTemplateUtil.getForEntity((RestTemplate)CRCSchedulerUtil.createOrGetRestTemplate(), (String)(CRCSchedulerUtil.getUrlSchedulerBase() + "/maxMemory"), Integer.class);
                }
                catch (CRCException oe) {
                    _logger.log(Level.WARNING, "Exception during getMaxMemory of another scheduler", oe);
                    throw oe;
                }
            }
            _logger.log(Level.WARNING, "Exception during getMaxMemory", e);
            throw e;
        }
    }

    private static InitComputationResponse init(String uriString) throws CRCException {
        _bCallInitLaunch = true;
        ResponseEntity response = RestTemplateUtil.postForEntity((RestTemplate)CRCSchedulerUtil.createOrGetRestTemplate(), (String)uriString, null, InitComputationResponse.class);
        return (InitComputationResponse)response.getBody();
    }

    public static InitComputationResponse initSingle() throws CRCException {
        return CRCSchedulerUtil.init(CRCSchedulerUtil.getUrlSchedulerBase() + "/computations/init-single");
    }

    public static InitComputationResponse initGrouped() throws CRCException {
        return CRCSchedulerUtil.init(CRCSchedulerUtil.getUrlSchedulerBase() + "/computations/init-grouped-parent");
    }

    public static void launchComputation(InitComputationResponse computInit, CRCEngineType engineType, String cmdParams, Integer memorySpace) throws CRCException {
        LaunchComputationRequest computRequest = new LaunchComputationRequest();
        computRequest.setComputationId(computInit.getId());
        computRequest.setMemorySpace(memorySpace);
        computRequest.setComputationParams(cmdParams);
        computRequest.setEngineType(engineType);
        RestTemplateUtil.postForEntity((RestTemplate)CRCSchedulerUtil.createOrGetRestTemplate(), (String)(CRCSchedulerUtil.getUrlSchedulerBase() + "/computations/launch"), (Object)computRequest, Void.class);
    }

    public static Map<String, Long> initAndLaunchMelComputationChilds(Long groupId, Map<String, String> cmdParams) throws CRCException {
        InitLaunchMelComputationChildsRequest computRequest = new InitLaunchMelComputationChildsRequest();
        computRequest.setGroupId(groupId);
        computRequest.setComputParams(cmdParams);
        InitLaunchMelComputationChildsResponse ids = (InitLaunchMelComputationChildsResponse)RestTemplateUtil.postForObject((RestTemplate)CRCSchedulerUtil.createOrGetRestTemplate(), (String)(CRCSchedulerUtil.getUrlSchedulerBase() + "/computations/init-launch-mel"), (Object)computRequest, InitLaunchMelComputationChildsResponse.class);
        return ids.getIdComputs();
    }

    public static void endComputation(Long id) throws CRCException {
        RestTemplateUtil.postForEntity((RestTemplate)CRCSchedulerUtil.createOrGetRestTemplate(), (String)(CRCSchedulerUtil.getUrlSchedulerBase() + "/computations/end/" + id), null, Void.class);
    }

    public static void abortComputation(Long id) throws CRCException {
        RestTemplateUtil.postForEntity((RestTemplate)CRCSchedulerUtil.createOrGetRestTemplate(), (String)(CRCSchedulerUtil.getUrlSchedulerBase() + "/computations/abort/" + id), null, Void.class);
    }

    public static void abortComputationGroup(Long groupId) throws CRCException {
        RestTemplateUtil.postForEntity((RestTemplate)CRCSchedulerUtil.createOrGetRestTemplate(), (String)(CRCSchedulerUtil.getUrlSchedulerBase() + "/computations/abort-group/" + groupId), null, Void.class);
    }

    public static Map<Long, ComputationRequestStatus> getStatusFromIds(List<Long> ids) throws CRCException {
        ResponseEntity response = RestTemplateUtil.postForEntity((RestTemplate)CRCSchedulerUtil.createOrGetRestTemplate(), (String)(CRCSchedulerUtil.getUrlSchedulerBase() + "/computations/status"), ids, Map.class);
        Map result = (Map)response.getBody();
        return result.entrySet().stream().collect(Collectors.toMap(s -> Long.parseLong((String)s.getKey()), s -> ComputationRequestStatus.valueOf((String)((String)s.getValue()))));
    }

    public static SftpInfosResponse refreshSftpInfos() throws CRCException {
        SftpInfosResponse res = (SftpInfosResponse)RestTemplateUtil.getForEntity((RestTemplate)CRCSchedulerUtil.createOrGetRestTemplate(), (String)(CRCSchedulerUtil.getUrlSchedulerBase() + "/credentials"), SftpInfosResponse.class);
        _logger.info("sftpInfos : " + res);
        return res;
    }

    public static Computation getComputation(Long computId) {
        Computation compute = null;
        try {
            compute = (Computation)RestTemplateUtil.getForEntity((RestTemplate)CRCSchedulerUtil.createOrGetRestTemplate(), (String)(CRCSchedulerUtil.getUrlSchedulerBase() + "/computations/" + computId), Computation.class);
        }
        catch (CRCException e) {
            _logger.log(Level.WARNING, "Exception during getComputation(" + computId + ")", e);
        }
        return compute;
    }

    public static String getMinSchedulerVersion() {
        return __MinSchedulerVersion;
    }

    public static boolean checkSchedulerVersion(String version) {
        Matcher curMatcher = __PatternVersion.matcher(version);
        if (!curMatcher.matches()) {
            return false;
        }
        Matcher minMatcher = __PatternVersion.matcher(__MinSchedulerVersion);
        if (!minMatcher.matches()) {
            return false;
        }
        for (int i = 1; i <= 3; ++i) {
            int min;
            int cur = Integer.parseInt(curMatcher.group(i));
            if (cur < (min = Integer.parseInt(minMatcher.group(i)))) {
                return false;
            }
            if (cur <= min) continue;
            return true;
        }
        return true;
    }

    public static void checkRemoteComputation(String title, String schedulerHost) {
        if (schedulerHost == null) {
            _logger.config(title + ": Undeclared");
            return;
        }
        _logger.config(title + ": " + schedulerHost);
        boolean bError = true;
        RestTemplate localRestTemplate = null;
        try {
            localRestTemplate = CRCSchedulerUtil.createOrGetRestTemplate(schedulerHost.startsWith("https"));
            bError = false;
        }
        catch (CRCException e) {
            _logger.log(Level.SEVERE, title + ": Impossible construire le contexte de connexion", e);
        }
        if (!bError) {
            bError = true;
            try {
                String version = (String)RestTemplateUtil.getForEntity((RestTemplate)localRestTemplate, (String)(schedulerHost + "/crcscheduler/version"), String.class);
                _logger.config(title + "(Version): " + version);
                if (!CRCSchedulerUtil.checkSchedulerVersion(version)) {
                    _logger.warning(title + "- Version must be greater or equal at 2.0.0");
                }
                bError = false;
            }
            catch (CRCClientException e) {
                _logger.warning(title + ": Inaccessible\n" + e.getMessage());
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "Another exception during find version for " + title, e);
            }
        }
        if (!bError) {
            try {
                String mapString = (String)RestTemplateUtil.getForEntity((RestTemplate)localRestTemplate, (String)(schedulerHost + "/crcscheduler/computations/managers"), String.class);
                Map realMap = (Map)new ObjectMapper().readValue(mapString, (TypeReference)new TypeReference<Map<String, ManagerInfos>>(){});
                _logger.config(title + "(Managers): => " + realMap.toString());
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "Another exception during find managers for " + title, e);
            }
        }
    }

    private static synchronized RestTemplate createOrGetRestTemplate() throws CRCException {
        return CRCSchedulerUtil.createOrGetRestTemplate(CRCSchedulerUtil.getUrlSchedulerBase().startsWith("https"));
    }

    public static RestTemplateConfig createRestTemplateConfig(boolean bEnableSSL) {
        RestTemplateConfig restTemplateConfig = new RestTemplateConfig();
        if (bEnableSSL) {
            restTemplateConfig.setHttps(true);
            restTemplateConfig.setExclusifCertificatePath(System.getProperty(PROP_DEFINE_CERTIFICAT_PATH));
            restTemplateConfig.setExclusifCertificatePasswd(System.getProperty(PROP_DEFINE_CERTIFICAT_PWD));
        } else {
            restTemplateConfig.setHttps(false);
        }
        restTemplateConfig.setTimeOut(Integer.getInteger(PROP_DEFINE_TIMEOUT, 20000).intValue());
        return restTemplateConfig;
    }

    private static synchronized RestTemplate createOrGetRestTemplate(boolean bEnableSSL) throws CRCException {
        if (_restTemplateConfig != null && _restTemplateConfig.isHttps() != bEnableSSL) {
            _restTemplateConfig = null;
            _restTemplate = null;
        }
        if (_restTemplateConfig == null) {
            _restTemplateConfig = CRCSchedulerUtil.createRestTemplateConfig(bEnableSSL);
        }
        if (_restTemplate == null) {
            _restTemplate = _restTemplateConfig.create();
        }
        return _restTemplate;
    }

    public static synchronized IOFilesExchange createOrGetIOFilesExchange(boolean sftp) throws CRCException {
        if (_ioFilesExchange != null) {
            if (sftp) {
                if (_ioFilesExchange instanceof IOFilesExchangeSFTP) {
                    if (_bCallInitLaunch) {
                        ((IOFilesExchangeSFTP)_ioFilesExchange).changeSftp(new SftpProperties(CRCSchedulerUtil.refreshSftpInfos()));
                    }
                } else {
                    _ioFilesExchange = null;
                }
            } else if (_ioFilesExchange instanceof IOFilesExchangeSFTP) {
                ((IOFilesExchangeSFTP)_ioFilesExchange).changeSftp(null);
                _ioFilesExchange = null;
            }
        }
        _bCallInitLaunch = false;
        if (_ioFilesExchange == null) {
            _ioFilesExchange = sftp ? CRCSchedulerUtil.createIOFilesExchangeSFTP(CRCSchedulerUtil.refreshSftpInfos()) : new IOFilesExchangeHTTP(CRCSchedulerUtil.createOrGetRestTemplate(), CRCSchedulerUtil.getUrlSchedulerBase());
        }
        return _ioFilesExchange;
    }

    public static IOFilesExchangeSFTP createIOFilesExchangeSFTP(SftpInfosResponse sftpInfo) throws CRCException {
        IOFilesExchangeSFTP result = new IOFilesExchangeSFTP(sftpInfo);
        boolean useSshKey = Boolean.getBoolean(PROP_DEFINE_SSH_KEY_MODE);
        if (useSshKey) {
            String keyPath = System.getProperty(PROP_DEFINE_SSH_IDENTITY, System.getProperty("user.home") + SSH_KEY_FILENAME);
            String user = System.getProperty(PROP_DEFINE_SSH_USER, System.getProperty("user.name"));
            result.setSshFileKey(keyPath).setSshUser(user);
        }
        return result;
    }

    public static HistoricalRequestTableModel getHistoricalRequests() {
        return _requestsModel;
    }

    static {
        _bCallInitLaunch = true;
        _logger = Logger.getLogger(CRCSchedulerUtil.class.getName());
        __PatternVersion = Pattern.compile("([0-9]+)\\.([0-9]+)\\.([0-9]+)(\\-.+)?");
        _requestsModel = new HistoricalRequestTableModel();
    }
}

