/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.client.historical;

import com.dassault.cecilia.crc.client.Computation;
import com.dassault.cecilia.crc.common.CRCEngineType;
import com.dassault.cecilia.crc.common.ComputationRequestStatus;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

public class HistoricalRequest
implements Comparable<HistoricalRequest> {
    private Long id;
    private Long groupId;
    private ComputationRequestStatus computationRequestStatus;
    private ZonedDateTime creationDate;
    private ZonedDateTime lastProgressionDate;
    private Long diffDuration;
    private Long computeDuration;
    private String historical;
    private String managerUrlBase;
    private CRCEngineType engineType;
    private Integer memorySpace;
    private Integer priority = 0;
    private String code;
    private String treePath;

    HistoricalRequest(Computation computation, String path) {
        this.treePath = path;
        this.update(computation);
    }

    public Long getId() {
        return this.id;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public ComputationRequestStatus getComputationRequestStatus() {
        return this.computationRequestStatus;
    }

    public ZonedDateTime getCreationDate() {
        return this.creationDate;
    }

    public ZonedDateTime getLastProgressionDate() {
        return this.lastProgressionDate;
    }

    public Long getDiffDuration() {
        return this.diffDuration;
    }

    public Long getComputeDuration() {
        return this.computeDuration;
    }

    public String getHistorical() {
        return this.historical;
    }

    public String getManagerUrlBase() {
        return this.managerUrlBase;
    }

    public CRCEngineType getEngineType() {
        return this.engineType;
    }

    public Integer getMemorySpace() {
        return this.memorySpace;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getCode() {
        return this.code;
    }

    public String getTreePath() {
        return this.treePath;
    }

    @Override
    public int compareTo(HistoricalRequest o) {
        return this.id.compareTo(o.id);
    }

    public void update(Computation computation) {
        this.id = computation.getId();
        this.groupId = computation.getGroupId();
        this.computationRequestStatus = computation.getComputationRequestStatus();
        this.creationDate = computation.getCreationDate();
        this.lastProgressionDate = computation.getLastProgressionDate();
        if (this.creationDate != null && this.lastProgressionDate != null) {
            this.diffDuration = ChronoUnit.MILLIS.between(this.creationDate, this.lastProgressionDate);
        }
        this.computeDuration = computation.getComputeDuration();
        this.historical = computation.getHistorical();
        this.engineType = computation.getEngineType();
        this.memorySpace = computation.getMemorySpace();
        this.managerUrlBase = computation.getManagerUrlBase();
        this.priority = computation.getPriority();
        StringBuilder buffer = new StringBuilder();
        switch (this.engineType) {
            case ARALIA4: {
                buffer.append("ARL4;");
                break;
            }
            case CECILIA_BDD: {
                buffer.append("CBDD;");
            }
        }
        buffer.append(this.memorySpace).append(";").append(this.priority);
        this.code = buffer.toString();
    }
}

