/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.client.historical;

import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.crc.client.historical.HistoricalRequest;
import com.dassault.cecilia.crc.client.historical.HistoricalRequestTableDlg;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class HistoricalRequestEditDlg
extends JDialogCecilia {
    HistoricalRequest _request;
    JTextField _ctrlID;
    JTextField _ctrlGroupID;
    JTextField _ctrlStatus;
    JTextField _ctrlEngine;
    JTextField _ctrlMemory;
    JTextField _ctrlPriority;
    JTextField _ctrlDateFirst;
    JTextField _ctrlDateLast;
    JTextField _ctrlDuration;
    JTextField _ctrlDurationCompute;
    JTextField _ctrlManager;

    public HistoricalRequestEditDlg(Window owner, HistoricalRequest request) {
        super(owner, ResMsgCecilia.getString("MENU_DISTRIB"), true);
        this._request = request;
        this.make();
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
    }

    private void make() {
        JPanel north = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 2, 2);
        north.add((Component)new JLabel("ID="), constraints);
        ++constraints.gridx;
        this._ctrlID = this.createCtrl(6, this.toStringWithNull(this._request.getId()));
        north.add((Component)this._ctrlID, constraints);
        ++constraints.gridx;
        north.add(new JLabel("GroupID="));
        ++constraints.gridx;
        this._ctrlGroupID = this.createCtrl(6, this.toStringWithNull(this._request.getGroupId()));
        north.add((Component)this._ctrlGroupID, constraints);
        ++constraints.gridx;
        north.add((Component)new JLabel("Status="), constraints);
        ++constraints.gridx;
        this._ctrlStatus = this.createCtrl(8, HistoricalRequestTableDlg.formatterStatus(this._request.getComputationRequestStatus()));
        north.add((Component)this._ctrlStatus, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        north.add((Component)new JLabel("Engine="), constraints);
        ++constraints.gridx;
        this._ctrlEngine = this.createCtrl(8, this.toStringWithNull(this._request.getEngineType()).toLowerCase());
        north.add((Component)this._ctrlEngine, constraints);
        ++constraints.gridx;
        north.add((Component)new JLabel("Memory="), constraints);
        ++constraints.gridx;
        this._ctrlMemory = this.createCtrl(4, this.toStringWithNull(this._request.getMemorySpace()));
        north.add((Component)this._ctrlMemory, constraints);
        ++constraints.gridx;
        north.add((Component)new JLabel("Priority="), constraints);
        ++constraints.gridx;
        this._ctrlPriority = this.createCtrl(3, this.toStringWithNull(this._request.getPriority()));
        north.add((Component)this._ctrlPriority, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        north.add((Component)new JLabel("Date(First)"), constraints);
        ++constraints.gridx;
        constraints.gridwidth = 3;
        this._ctrlDateFirst = this.createCtrl(20, HistoricalRequestTableDlg.__formatterTooltip.format(this._request.getCreationDate()));
        north.add((Component)this._ctrlDateFirst, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        north.add((Component)new JLabel("Date(Last)"), constraints);
        ++constraints.gridx;
        constraints.gridwidth = 3;
        this._ctrlDateLast = this.createCtrl(20, HistoricalRequestTableDlg.__formatterTooltip.format(this._request.getLastProgressionDate()));
        north.add((Component)this._ctrlDateLast, constraints);
        constraints.gridx += 3;
        constraints.gridwidth = 1;
        north.add((Component)new JLabel("Duration"), constraints);
        ++constraints.gridx;
        this._ctrlDuration = this.createCtrl(6, this.toStringWithNull(this._request.getDiffDuration()));
        north.add((Component)this._ctrlDuration, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        north.add((Component)new JLabel("Manager"), constraints);
        ++constraints.gridx;
        constraints.gridwidth = 3;
        this._ctrlManager = this.createCtrl(20, this.toStringWithNull(this._request.getManagerUrlBase()));
        north.add((Component)this._ctrlManager, constraints);
        constraints.gridx += 3;
        constraints.gridwidth = 1;
        north.add((Component)new JLabel("Compute"), constraints);
        ++constraints.gridx;
        this._ctrlDurationCompute = this.createCtrl(6, this.toStringWithNull(this._request.getComputeDuration()));
        north.add((Component)this._ctrlDurationCompute, constraints);
        JTextArea center = new JTextArea(8, 40);
        center.setText(this._request.getHistorical());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)north, "North");
        this.getContentPane().add((Component)center, "Center");
        this.getContentPane().add((Component)this.createButPanelClose(), "South");
    }

    private String toStringWithNull(Object obj) {
        if (obj == null) {
            return "-";
        }
        return obj.toString();
    }

    private JTextField createCtrl(int col, String txt) {
        JTextField ctrl = new JTextField(col);
        ctrl.setEditable(false);
        ctrl.setText(txt);
        return ctrl;
    }
}

