/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.client.historical;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.crc.client.CRCSchedulerUtil;
import com.dassault.cecilia.crc.client.Computation;
import com.dassault.cecilia.crc.client.historical.HistoricalRequest;
import com.dassault.cecilia.crc.client.historical.HistoricalRequestEditDlg;
import com.dassault.cecilia.crc.client.historical.HistoricalRequestTableModel;
import com.dassault.cecilia.crc.common.ComputationRequestStatus;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class HistoricalRequestTableDlg
extends JDialogCecilia {
    static HistoricalRequestTableDlg __dlg = null;
    static Object __dlgLocker = new Object();
    private static DateTimeFormatter __formatterText = DateTimeFormatter.ofPattern("MM/dd - HH:mm:ss");
    static DateTimeFormatter __formatterTooltip = DateTimeFormatter.ofPattern("yyyy/MM/dd - HH:mm:ss.SSS");
    CeciliaTable _table;
    CeciliaAction _ctrlDel;
    CeciliaAction _ctrlRefresh;
    CeciliaAction _ctrlEdit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HistoricalRequestTableDlg getInstance(CAppl application) {
        if (__dlg == null) {
            Object object = __dlgLocker;
            synchronized (object) {
                if (__dlg == null) {
                    HistoricalRequestTableDlg dlg = new HistoricalRequestTableDlg(application.getTopWindow());
                    if (__dlg == null) {
                        __dlg = dlg;
                    }
                }
            }
        }
        return __dlg;
    }

    HistoricalRequestTableDlg(Window owner) {
        super(owner, ResMsgCecilia.getString("MENU_DISTRIB"), false);
        this.make();
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
    }

    static String formatterStatus(ComputationRequestStatus status) {
        switch (status) {
            case REQUEST_ABORTED: {
                return "Aborted";
            }
            case REQUEST_ERROR: {
                return "Error";
            }
            case REQUEST_INITIALIZED: {
                return "Init";
            }
            case REQUEST_READY_TO_LAUNCH: {
                return "Waiting";
            }
            case REQUEST_SENT_TO_MANAGER: {
                return "Compute";
            }
            case RESULT_RECEIVED_FROM_MANAGER: {
                return "Available";
            }
            case RESULT_RECEIVED_BY_CLIENT: {
                return "Finnish";
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + status);
    }

    private void make() {
        this.getContentPane().setLayout(new BorderLayout());
        this.createTable();
        this.createTableRenderer();
        this.createTableSorter();
        this.createTableActions();
        JScrollPane scroll = new JScrollPane(this._table);
        scroll.setComponentPopupMenu(this.createTablePopup());
        scroll.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        this.getContentPane().add((Component)scroll, "Center");
        this.getContentPane().add((Component)this.createButPanelClose(false), "South");
    }

    private void createTable() {
        this._table = new CeciliaTable(CRCSchedulerUtil.getHistoricalRequests()){

            @Override
            public void createDefaultColumnsFromModel() {
                super.createDefaultColumnsFromModel();
                TableColumnModel colModel = this.getColumnModel();
                block10: for (int c = 0; c < this.getColumnCount(); ++c) {
                    switch (c) {
                        case 0: {
                            colModel.getColumn(c).setPreferredWidth(150);
                            continue block10;
                        }
                        case 1: {
                            colModel.getColumn(c).setPreferredWidth(75);
                            continue block10;
                        }
                        case 2: {
                            colModel.getColumn(c).setPreferredWidth(150);
                            continue block10;
                        }
                        case 3: {
                            colModel.getColumn(c).setPreferredWidth(150);
                            continue block10;
                        }
                        case 4: {
                            colModel.getColumn(c).setPreferredWidth(75);
                            continue block10;
                        }
                        case 5: {
                            colModel.getColumn(c).setPreferredWidth(75);
                            continue block10;
                        }
                        case 6: {
                            colModel.getColumn(c).setPreferredWidth(100);
                            continue block10;
                        }
                        case 7: {
                            colModel.getColumn(c).setPreferredWidth(300);
                        }
                    }
                }
            }

            @Override
            protected void doubleClickLeft(MouseEvent e) {
                int rowView = HistoricalRequestTableDlg.this._table.rowAtPoint(e.getPoint());
                if (rowView == -1) {
                    return;
                }
                HistoricalRequestTableDlg.this.doEdit(rowView);
            }
        };
        this._table.setPreferredScrollableViewportSize(new Dimension(700, 300));
    }

    private void createTableRenderer() {
        this._table.setDefaultRenderer(HistoricalRequest.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable thisTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(HistoricalRequestTableDlg.this._table, value, isSelected, hasFocus, row, column);
                if (value instanceof HistoricalRequest) {
                    HistoricalRequest request = (HistoricalRequest)value;
                    StringBuilder buffer = new StringBuilder();
                    if (request.getGroupId() == null) {
                        buffer.append("MCS: ");
                    } else if (request.getGroupId().equals(request.getId())) {
                        buffer.append("MEL: ");
                    } else {
                        buffer.append(" |------- ");
                    }
                    buffer.append(request.getId());
                    this.setText(buffer.toString());
                }
                return this;
            }
        });
        this._table.setDefaultRenderer(ComputationRequestStatus.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable thisTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(HistoricalRequestTableDlg.this._table, value, isSelected, hasFocus, row, column);
                if (value instanceof ComputationRequestStatus) {
                    this.setText(HistoricalRequestTableDlg.formatterStatus((ComputationRequestStatus)value));
                    this.setToolTipText(value.toString());
                }
                return this;
            }
        });
        this._table.setDefaultRenderer(ZonedDateTime.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable thisTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(HistoricalRequestTableDlg.this._table, value, isSelected, hasFocus, row, column);
                if (value instanceof ZonedDateTime) {
                    ZonedDateTime date = (ZonedDateTime)value;
                    this.setText(date.format(__formatterText));
                    this.setToolTipText(date.format(__formatterTooltip));
                }
                return this;
            }
        });
    }

    private void createTableSorter() {
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this._table.getModel());
        this._table.setRowSorter(sorter);
        this._table.setSelectionMode(2);
    }

    private void createTableActions() {
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx;
                if (HistoricalRequestTableDlg.this._table == null) {
                    return;
                }
                int[] views = HistoricalRequestTableDlg.this._table.getSelectedRows();
                if (views.length == 0) {
                    return;
                }
                HistoricalRequestTableDlg.this._table.clearSelection();
                int[] models = new int[views.length];
                for (idx = views.length - 1; idx >= 0; --idx) {
                    models[idx] = HistoricalRequestTableDlg.this._table.convertRowIndexToModel(views[idx]);
                }
                Arrays.sort(models);
                for (idx = models.length - 1; idx >= 0; --idx) {
                    CRCSchedulerUtil.getHistoricalRequests().delComputation(models[idx], models[idx]);
                }
            }
        };
        this._table.getActionMap().put("DELETE", this._ctrlDel);
        this._table.getInputMap(0).put(KeyStroke.getKeyStroke("DELETE"), "DELETE");
        this._ctrlRefresh = new CeciliaAction(ResIcoCore.getImageIcon("BUT_REFRESH"), ResMsgVoc.getString("VOC_REFRESH")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HistoricalRequestTableDlg.this._table == null) {
                    return;
                }
                int[] views = HistoricalRequestTableDlg.this._table.getSelectedRows();
                if (views.length == 0) {
                    return;
                }
                HistoricalRequestTableModel tableModel = CRCSchedulerUtil.getHistoricalRequests();
                for (int idx = views.length - 1; idx >= 0; --idx) {
                    int modelIdx = HistoricalRequestTableDlg.this._table.convertRowIndexToModel(views[idx]);
                    HistoricalRequest request = (HistoricalRequest)tableModel.getValueAt(modelIdx, 0);
                    Computation computation = CRCSchedulerUtil.getComputation(request.getId());
                    request.update(computation);
                    tableModel.fireTableChanged(new TableModelEvent(tableModel, modelIdx));
                }
            }
        };
        this._table.getActionMap().put("REFRESH", this._ctrlRefresh);
        this._table.getInputMap(0).put(KeyStroke.getKeyStroke("F5"), "REFRESH");
        this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HistoricalRequestTableDlg.this._table == null) {
                    return;
                }
                int[] views = HistoricalRequestTableDlg.this._table.getSelectedRows();
                if (views.length != 1) {
                    return;
                }
                HistoricalRequestTableDlg.this.doEdit(views[0]);
            }
        };
        this._table.getActionMap().put("EDIT", this._ctrlEdit);
        this._table.getInputMap(0).put(KeyStroke.getKeyStroke("F12"), "EDIT");
        this._table.getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "EDIT");
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(this._ctrlEdit);
        popup.add(this._ctrlRefresh);
        popup.add(this._ctrlDel);
        this._table.setInheritsPopupMenu(true);
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                HistoricalRequestTableDlg.this.refreshActions();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        return popup;
    }

    private void refreshActions() {
        if (this._table == null) {
            return;
        }
        int nbrSelect = this._table.getSelectedRowCount();
        this._ctrlDel.setEnabled(nbrSelect > 0);
        this._ctrlRefresh.setEnabled(nbrSelect > 0);
        this._ctrlEdit.setEnabled(nbrSelect == 1);
    }

    protected void doEdit(int viewIdx) {
        int modelIdx = this._table.convertRowIndexToModel(viewIdx);
        HistoricalRequestTableModel tableModel = CRCSchedulerUtil.getHistoricalRequests();
        HistoricalRequest request = (HistoricalRequest)tableModel.getValueAt(modelIdx, 0);
        HistoricalRequestEditDlg dlg = new HistoricalRequestEditDlg((Window)this, request);
        dlg.setVisible(true);
    }
}

