/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.client.historical;

import com.dassault.cecilia.crc.client.Computation;
import com.dassault.cecilia.crc.client.historical.HistoricalRequest;
import com.dassault.cecilia.crc.common.ComputationRequestStatus;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class HistoricalRequestTableModel
implements TableModel {
    List<HistoricalRequest> _requests = new ArrayList<HistoricalRequest>();
    ArrayList<TableModelListener> _listener = new ArrayList();

    @Override
    public int getRowCount() {
        return this._requests.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Request";
            }
            case 1: {
                return "Statut";
            }
            case 2: {
                return "Date (start)";
            }
            case 3: {
                return "Date (stop)";
            }
            case 4: {
                return "Duration (all)";
            }
            case 5: {
                return "Duration (compute)";
            }
            case 6: {
                return "Other";
            }
            case 7: {
                return "Path";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return HistoricalRequest.class;
            }
            case 1: {
                return ComputationRequestStatus.class;
            }
            case 2: {
                return ZonedDateTime.class;
            }
            case 3: {
                return ZonedDateTime.class;
            }
            case 4: {
                return Long.class;
            }
            case 5: {
                return Long.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        HistoricalRequest req = this._requests.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return req;
            }
            case 1: {
                return req.getComputationRequestStatus();
            }
            case 2: {
                return req.getCreationDate();
            }
            case 3: {
                return req.getLastProgressionDate();
            }
            case 4: {
                return req.getDiffDuration();
            }
            case 5: {
                return req.getComputeDuration();
            }
            case 6: {
                return req.getCode();
            }
            case 7: {
                return req.getTreePath();
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (!this._listener.contains(l)) {
            this._listener.add(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this._listener.remove(l);
    }

    public void fireTableChanged(TableModelEvent e) {
        for (int i = this._listener.size() - 1; i >= 0; --i) {
            this._listener.get(i).tableChanged(e);
        }
    }

    public void addComputation(Computation computation, String path) {
        if (this._requests.add(new HistoricalRequest(computation, path))) {
            int row = this._requests.size() - 1;
            this.fireTableChanged(new TableModelEvent(this, row, row, -1, 1));
        }
    }

    public void delComputation(int min, int max) {
        if (min > max) {
            int tmp = max;
            max = min;
            min = tmp;
        }
        for (int i = max; i >= min; --i) {
            this._requests.remove(i);
        }
        this.fireTableChanged(new TableModelEvent(this, min, max, -1, -1));
    }
}

