/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db;

import com.dassault.cecilia.db.IGroup;

public class DBAccess {
    IGroup _group;
    Right _right;

    public DBAccess() {
    }

    public DBAccess(DBAccess src) {
        this();
        this._group = src._group;
        this._right = src._right;
    }

    public IGroup getGroup() {
        return this._group;
    }

    public DBAccess setGroup(IGroup group) {
        this._group = group;
        return this;
    }

    public Right getRight() {
        return this._right;
    }

    public DBAccess setRight(Right right) {
        this._right = right;
        return this;
    }

    public static Right parseRight(int dbNum) {
        switch (dbNum) {
            case 0: {
                return Right.NONE;
            }
            case 1: {
                return Right.READ;
            }
            case 2: {
                return Right.WRITE;
            }
            case 3: {
                return Right.INTEGRATE;
            }
        }
        return Right.NONE;
    }

    public static int formatRight(Right right) {
        switch (right) {
            case NONE: {
                return 0;
            }
            case READ: {
                return 1;
            }
            case WRITE: {
                return 2;
            }
            case INTEGRATE: {
                return 3;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        switch (this._right) {
            case NONE: {
                buffer.append("_(");
                break;
            }
            case INTEGRATE: {
                buffer.append("i(");
                break;
            }
            case READ: {
                buffer.append("r(");
                break;
            }
            case WRITE: {
                buffer.append("w(");
            }
        }
        buffer.append(this._group.getID()).append(")").append(this._group.getName());
        return buffer.toString();
    }

    public static enum Right {
        NONE,
        INTEGRATE,
        READ,
        WRITE;

        String _toXml = this.toString().toLowerCase();

        public char getChar() {
            return this._toXml.charAt(0);
        }

        public String toXML() {
            return this._toXml;
        }

        public static Right fromXML(String key) {
            for (Right right : Right.values()) {
                if (!right._toXml.equals(key)) continue;
                return right;
            }
            return null;
        }
    }
}

