/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBGlobEvent {
    private static Logger _LOG = Logger.getLogger(DBGlobEvent.class.getPackage().getName());
    public static final short LIMIT_COMMENT = 255;
    protected static final short MASK_TYPE = 15;
    protected static final short MASK_LINK = 240;
    DBFolder _dbFolder;
    DBObject _dbObject;
    String _strName;
    String _strComment;
    Type _type;
    Link _link;
    String _strLob;

    public DBGlobEvent(DBObject dbObj) {
        this._dbObject = dbObj;
        this._dbFolder = this._dbObject == null ? null : this._dbObject.getFolder();
        this._link = Link.NONE;
        this._type = Type.ROOT;
    }

    public DBGlobEvent setFolder(DBFolder dbFolder) {
        this._dbFolder = dbFolder;
        return this;
    }

    public DBGlobEvent setObject(DBObject dbObject) {
        this._dbObject = dbObject;
        return this;
    }

    public DBGlobEvent setName(String value) {
        this._strName = value;
        return this;
    }

    public DBGlobEvent setComment(String value) {
        this._strComment = value;
        return this;
    }

    public DBGlobEvent setType(Type value) {
        this._type = value;
        return this;
    }

    public DBGlobEvent setLink(Link value) {
        this._link = value;
        return this;
    }

    public DBGlobEvent setLOb(String value) {
        this._strLob = value;
        return this;
    }

    public String getName() {
        return this._strName;
    }

    public String getComment() {
        return this._strComment;
    }

    public String getLOb() {
        return this._strLob;
    }

    public Type getType() {
        return this._type;
    }

    public Link getLink() {
        return this._link;
    }

    public DBFolder getFolder() {
        return this._dbFolder;
    }

    public DBObject getObject() {
        return this._dbObject;
    }

    public short getCode() {
        return (short)(this._type.getCode() + this._link.getCode());
    }

    public static Type convertCodeToType(short dbCode) {
        return Type.getType((short)(dbCode & 0xF));
    }

    public static Link convertCodeToLink(short dbCode) {
        return Link.getLink((short)(dbCode & 0xF0));
    }

    public static String convertBlobToLOb(InputStream binaryStream) {
        StringWriter writer = new StringWriter(2048);
        InputStreamReader reader = new InputStreamReader(binaryStream, StandardCharsets.UTF_8);
        try {
            int len;
            char[] buffer = new char[1024];
            while ((len = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            LogUtility.logException((Logger)_LOG, (Level)Level.INFO, (Throwable)e, (String)"", (int)0, (int)5);
            return "";
        }
        return writer.toString();
    }

    public InputStream getLObStream() {
        return new ByteArrayInputStream(this._strLob.getBytes(StandardCharsets.UTF_8));
    }

    public static enum Link {
        NONE(0),
        TREE(16),
        DSF(32);

        short _code;
        static Map<Short, Link> _map;

        private Link(int code) {
            this._code = (short)code;
        }

        public short getCode() {
            return this._code;
        }

        public static synchronized Link getLink(short code) {
            if (_map == null) {
                _map = new HashMap<Short, Link>();
                for (Link cur : Link.values()) {
                    _map.put(cur.getCode(), cur);
                }
            }
            return _map.get(code);
        }
    }

    public static enum Type {
        ROOT(1),
        GATE(2),
        BASIC(3);

        short _code;
        static Map<Short, Type> _map;

        private Type(int code) {
            this._code = (short)code;
        }

        public short getCode() {
            return this._code;
        }

        public static synchronized Type getType(short code) {
            if (_map == null) {
                _map = new HashMap<Short, Type>();
                for (Type cur : Type.values()) {
                    _map.put(cur.getCode(), cur);
                }
            }
            return _map.get(code);
        }
    }
}

