/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db;

import com.dassault.cecilia.db.DBFlagItem;
import com.dassault.cecilia.db.IGroup;
import com.dassault.cecilia.db.IUser;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;

public class DBGroup
extends DBFlagItem
implements IGroup {
    String _name = null;
    String _description = null;
    Set<IUser> _users = new LinkedHashSet<IUser>();

    public DBGroup() {
    }

    public DBGroup(long id, String name) {
        super(id);
        this._name = name;
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof IGroup;
    }

    @Override
    public String toString() {
        StringBuilder debug = new StringBuilder();
        debug.append("Group:").append(this._id).append(",").append(this._name).append(",");
        String sep = "[";
        for (IUser dbUser : this._users) {
            debug.append(sep);
            sep = ",";
            debug.append("{").append(dbUser.getID()).append(",").append(dbUser.getLogin()).append("}");
        }
        debug.append("]");
        return debug.toString();
    }

    @Override
    public String getName() {
        return this._name;
    }

    public DBGroup setName(String name) {
        this._name = name;
        return this;
    }

    public String getDescription() {
        return this._description;
    }

    public DBGroup setDescription(String description) {
        this._description = description;
        return this;
    }

    public Set<IUser> getUsers() {
        return this._users;
    }

    public DBGroup setUsers(Set<IUser> users) {
        this._users = users;
        return this;
    }

    public boolean addUser(IUser user) {
        if (!this._users.contains(user)) {
            this._users.add(user);
            return true;
        }
        return false;
    }

    public boolean delUser(IUser user) {
        return this._users.remove(user);
    }

    public String getUserInformations() {
        StringBuilder sb = new StringBuilder();
        for (IUser user : this._users) {
            sb.append(user.getLogin()).append(", ");
        }
        int len = sb.length();
        if (len > 2) {
            sb.delete(len - 2, len);
        }
        return sb.toString();
    }

    @Override
    public boolean isAdmin() {
        return (this._flags & 0x800000) != 0;
    }

    public static Comparator<? super IGroup> getComparatorName() {
        return new Comparator<IGroup>(){

            @Override
            public int compare(IGroup g1, IGroup g2) {
                return g1.getName().compareTo(g2.getName());
            }
        };
    }
}

