/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db;

import com.dassault.cecilia.db.DBItem;
import com.dassault.cecilia.db.DBObject;
import java.util.regex.Pattern;

public class DBObjProperty
extends DBItem
implements Comparable<DBObjProperty> {
    public static final String KEY_BTP_SUBS_DATE = "btp.substantiation.date";
    public static final String KEY_OBJECT_RELEASE = "object.release";
    public static final String KEY_OBJECT_CREATOR = "object.creator";
    public static final String KEY_FMEA_MODEL_ID = "fmea.model.id";
    public static final String KEY_LAETITIA_ID = "laetitia.id";
    public static final String KEY_EXTERNAL_FIELD = "external.field";
    public static final String TYPE_DATE = "Date";
    public static final String TYPE_TIME = "Time";
    public static final String TYPE_LONG = "Long";
    public static final String TYPE_DOUBLE = "Double";
    public static final String TYPE_STRING = "String";
    DBObject _obj;
    String _name;
    String _value;
    String _type;
    boolean _bAtDelete = false;
    private static final Pattern _LONG_PATTERN = Pattern.compile("[0-9]{1,10}");

    public DBObjProperty() {
    }

    public DBObjProperty(DBObjProperty src) {
        this();
        this.copyFrom(src);
    }

    public void copyFrom(DBObjProperty src) {
        super.copyFrom(src);
        this._name = src._name;
        this._value = src._value;
        this._type = src._type;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof DBObjProperty;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjProp:").append(this._id).append(",").append(this._name);
        sb.append(",").append(this._value).append(",").append(this._type);
        return sb.toString();
    }

    @Override
    public int compareTo(DBObjProperty o) {
        return this.getName().compareTo(o.getName());
    }

    public DBObject getObject() {
        return this._obj;
    }

    public DBObjProperty setObject(DBObject obj) {
        if (this._obj != null && obj != null && !this._obj.equals(obj)) {
            _LOG.warning("ObjProperty : affectation \u00e0 un nouvel objet.");
        }
        this._obj = obj;
        return this;
    }

    public String getName() {
        return this._name;
    }

    public DBObjProperty setName(String name) {
        this._name = name;
        return this;
    }

    public String getValue() {
        return this._value;
    }

    public DBObjProperty setValue(String value) {
        this._value = value;
        return this;
    }

    public String getType() {
        return this._type;
    }

    public DBObjProperty setType(String type) {
        this._type = type;
        return this;
    }

    public boolean isAtDeleted() {
        return this._bAtDelete;
    }

    public DBObjProperty setAtDeleted(boolean value) {
        this._bAtDelete = value;
        return this;
    }

    public static long getObjectRelease(DBObjProperty property) {
        if (property == null) {
            return -1L;
        }
        if (_LONG_PATTERN.matcher(property.getValue()).matches()) {
            return Long.parseLong(property.getValue());
        }
        _LOG.warning("Cette propriete ne semble pas etre un long : " + property.toString());
        return -1L;
    }
}

