/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db;

import com.dassault.cecilia.db.DBFolder;
import java.util.logging.Logger;

public class DBRelation {
    private static Logger _LOG = Logger.getLogger(DBRelation.class.getPackage().getName());
    public static final String TYPE_ATTRIBUTE = "ATTRIBUTE";
    public static final String TYPE_PARAMETER = "PARAMETER";
    public static final String TYPE_CCF = "CCF_MODEL";
    public static final String TYPE_FRB_APPL = "FRB_APPL";
    public static final String TYPE_FRB_AUTHOR = "FRB_AUTHOR";
    public static final String TYPE_FRB_SUBST = "FRB_SUBST";
    public static final String TYPE_FRB_MODEL = "LAW_MODEL";
    public static final String TYPE_ARB_TREE = "TREE_V";
    public static final String TYPE_ARB_BEQ = "BEQ_V";
    public static final String TYPE_ARB_DSF = "DSF_V";
    public static final String TYPE_FMEA_TABLE = "FMEA";
    public static final String TYPE_FMEA_MODEL = "FMEA_MODEL";
    public static final String TYPE_FMEA_V = "FMEA_V";
    public static final String TYPE_OCAS_TYPE = "OA_TYPE";
    public static final String TYPE_OCAS_OPER = "OA_OPER";
    public static final String TYPE_OCAS_COMP = "OA_COMP";
    public static final String TYPE_OCAS_EQUIP = "OA_EQUIP";
    public static final String TYPE_OCAS_SYST = "OA_SYST";
    public static final String TYPE_OCAS_IMAG = "OA_IMAG";
    public static final String TYPE_PROJECT = "PROJECT";
    public static final String TYPE_WORKING = "WORKING";
    DBFolder _dbSrc;
    DBFolder _dbDest;
    String _strSrc;
    String _strDest;
    private static final String SRC = "SRC";
    private static final String DEST = "DEST";

    public static String defineTypeFromFolder(DBFolder dbSrc, String def) {
        switch (dbSrc.getFamily()) {
            case TYPE: {
                return TYPE_OCAS_TYPE;
            }
            case OPERATOR: {
                return TYPE_OCAS_OPER;
            }
            case COMPONENT: {
                return TYPE_OCAS_COMP;
            }
            case EQUIPMENT: {
                return TYPE_OCAS_EQUIP;
            }
            case IMAG: {
                return TYPE_OCAS_IMAG;
            }
            case ATTRIBUTE: {
                return TYPE_ATTRIBUTE;
            }
            case PARAMETER: {
                return TYPE_PARAMETER;
            }
            case CCF_MODEL: {
                return TYPE_CCF;
            }
            case BTP_APPLICATION: {
                return TYPE_FRB_APPL;
            }
            case BTP_AUTHOR: {
                return TYPE_FRB_AUTHOR;
            }
            case BTP_MODEL: {
                return TYPE_FRB_MODEL;
            }
            case BTP_SUBSTANTIATION: {
                return TYPE_FRB_SUBST;
            }
            case FMEA_MODEL: {
                return TYPE_FMEA_MODEL;
            }
            case PROJECT: {
                switch (dbSrc.getFamilyFlag()) {
                    case 2: {
                        return TYPE_ARB_TREE;
                    }
                    case 5: {
                        return TYPE_ARB_BEQ;
                    }
                    case 3: {
                        return TYPE_ARB_DSF;
                    }
                    case 4: {
                        return TYPE_FMEA_V;
                    }
                    case 1: {
                        return TYPE_OCAS_SYST;
                    }
                }
            }
        }
        return def;
    }

    public DBRelation(DBFolder dbSrc, DBFolder dbDest) {
        this._dbSrc = dbSrc;
        this._dbDest = dbDest;
        this._strSrc = DBRelation.defineTypeFromFolder(dbSrc, SRC);
        this._strDest = DBRelation.defineTypeFromFolder(dbDest, DEST);
    }

    public DBRelation(DBFolder dbSrc, String strSrc, DBFolder dbDest, String strDest) {
        this._dbSrc = dbSrc;
        this._dbDest = dbDest;
        if (strSrc.length() > 10) {
            _LOG.severe("Le type d'une source d'une relation est trop grand : " + strSrc);
            this._strSrc = strSrc.substring(0, 10);
        } else {
            this._strSrc = strSrc;
        }
        if (strDest.length() > 10) {
            _LOG.severe("Le type d'une source d'une relation est trop grand : " + strSrc);
            this._strDest = strDest.substring(0, 10);
        } else {
            this._strDest = strDest;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DBRelation)) {
            return false;
        }
        DBRelation db = (DBRelation)obj;
        if (!this._dbSrc.equals(db._dbSrc)) {
            return false;
        }
        if (!this._dbDest.equals(db._dbDest)) {
            return false;
        }
        if (!this._strSrc.equals(db._strSrc)) {
            return false;
        }
        return this._strDest.equals(db._strDest);
    }

    public int hashCode() {
        int result = 11;
        result += 13 * this._dbSrc.hashCode();
        result += 17 * this._strSrc.hashCode();
        result += 19 * this._dbDest.hashCode();
        return result += 23 * this._strDest.hashCode();
    }

    public String toString() {
        StringBuilder debug = new StringBuilder();
        debug.append("Relation:");
        debug.append(this._dbSrc.getRefPath()).append("[").append(this._strSrc).append("]");
        debug.append(" => ");
        debug.append(this._dbDest.getRefPath()).append("[").append(this._strDest).append("]");
        return debug.toString();
    }

    public DBFolder getSource() {
        return this._dbSrc;
    }

    public DBFolder getDestination() {
        return this._dbDest;
    }

    public String getTypeSource() {
        return this._strSrc;
    }

    public String getTypeDestination() {
        return this._strDest;
    }

    public DBRelation setSource(DBFolder fol) {
        this._dbSrc = fol;
        return this;
    }

    public DBRelation setDestination(DBFolder fol) {
        this._dbDest = fol;
        return this;
    }

    public DBRelation setTypeSource(String type) {
        this._strSrc = type;
        return this;
    }

    public DBRelation setTypeDestination(String type) {
        this._strDest = type;
        return this;
    }
}

