/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db;

import com.dassault.cecilia.db.DBFlagItem;
import com.dassault.cecilia.db.IGroup;
import com.dassault.cecilia.db.IUser;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DBUser
extends DBFlagItem
implements IUser {
    private static final String DEFAULT_PASSWD = "0A09081901";
    String _login = null;
    String _passwd = "0A09081901";
    String _name = "";
    String _description = "";
    IGroup _defaultGroup = null;
    Set<IGroup> _groups = new LinkedHashSet<IGroup>();
    Map<String, String> _preferencies = new HashMap<String, String>();
    private Boolean _bIsAdmin = null;
    private Object _lockerIsAdmin = new Object();

    public DBUser() {
    }

    public DBUser(long id, String login) {
        super(id);
        this._login = login;
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public DBUser setFlags(int flags) {
        return (DBUser)super.setFlags(flags);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof IUser;
    }

    @Override
    public String toString() {
        StringBuilder debug = new StringBuilder();
        debug.append("User:").append(this._id).append(",").append(this._login);
        if (this._name != null && this._name.length() > 0) {
            debug.append("(=").append(this._name).append(")");
        }
        String sep = ",[";
        for (IGroup dbGroup : this._groups) {
            debug.append(sep);
            sep = ",";
            debug.append("{").append(dbGroup.getID()).append(",").append(dbGroup.getName());
            if (dbGroup == this._defaultGroup) {
                debug.append(",default");
            }
            debug.append("}");
        }
        debug.append("]");
        return debug.toString();
    }

    public String getName() {
        return this._name;
    }

    public DBUser setName(String name) {
        this._name = name;
        return this;
    }

    public String getPassword() {
        return this._passwd;
    }

    public DBUser setPassword(String passwd) {
        this._passwd = passwd;
        return this;
    }

    public String getDescription() {
        return this._description;
    }

    public DBUser setDescription(String description) {
        this._description = description;
        return this;
    }

    @Override
    public String getLogin() {
        return this._login;
    }

    public DBUser setLogin(String login) {
        this._login = login;
        return this;
    }

    public IGroup getDefaultGroup() {
        return this._defaultGroup;
    }

    public DBUser setDefaultGroup(IGroup defaultGroup) {
        this._defaultGroup = defaultGroup;
        return this;
    }

    public String getGroupInformations() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._defaultGroup.getName()).append("*");
        for (IGroup group : this._groups) {
            if (group.equals(this._defaultGroup)) continue;
            sb.append(", ").append(group.getName());
        }
        return sb.toString();
    }

    public Set<IGroup> getGroups() {
        return this._groups;
    }

    public DBUser setGroups(Set<IGroup> groups) {
        this._bIsAdmin = null;
        this._groups = groups;
        return this;
    }

    public boolean addGroup(IGroup group) {
        if (!this._groups.contains(group)) {
            this._bIsAdmin = null;
            this._groups.add(group);
            return true;
        }
        return false;
    }

    public boolean delGroup(IGroup group) {
        this._bIsAdmin = null;
        return this._groups.remove(group);
    }

    public void clearGroups() {
        this._groups.clear();
    }

    @Override
    public boolean isMasterAdmin() {
        return (this._flags & 0x800000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAdmin() {
        if (this.isMasterAdmin()) {
            return true;
        }
        if (this._bIsAdmin == null) {
            Object object = this._lockerIsAdmin;
            synchronized (object) {
                for (IGroup iGroup : this._groups) {
                    if (!iGroup.isAdmin()) continue;
                    this._bIsAdmin = true;
                }
                if (this._bIsAdmin == null) {
                    this._bIsAdmin = false;
                }
            }
        }
        return this._bIsAdmin;
    }

    public Map<String, String> getPreferencies() {
        return this._preferencies;
    }

    public DBUser setPreferencies(String key, String value) {
        this._preferencies.put(key, value);
        return this;
    }

    public static Comparator<? super DBUser> getComparatorName() {
        return new Comparator<DBUser>(){

            @Override
            public int compare(DBUser u1, DBUser u2) {
                return u1.getName().compareTo(u2.getName());
            }
        };
    }

    public static Comparator<? super IUser> getComparatorLogin() {
        return new Comparator<IUser>(){

            @Override
            public int compare(IUser u1, IUser u2) {
                return u1.getLogin().compareTo(u2.getLogin());
            }
        };
    }
}

