/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

class DAOClass {
    static Logger _LOG = Logger.getLogger(DAOClass.class.getPackage().getName());

    DAOClass() {
    }

    protected void logError(String msg) {
        _LOG.info(msg);
    }

    protected void logException(Exception exc, String methodID) {
        if (exc instanceof SQLException) {
            this.logSQLException((SQLException)exc, methodID);
        } else {
            _LOG.warning("Exception[" + methodID + "]:" + exc.getMessage());
            _LOG.log(Level.FINE, "Information:", exc);
        }
    }

    protected void logSQLException(SQLException exc, String methodID) {
        SQLException e = exc;
        do {
            _LOG.warning("SQLException[" + methodID + "][" + e.getSQLState() + "][" + e.getErrorCode() + "]:" + e.getMessage());
        } while ((e = e.getNextException()) != null);
        _LOG.log(Level.FINE, "SQLException:" + methodID, exc);
    }
}

