/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.def;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAORelation;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class DefaultRelation
extends DAORelation {
    protected Connection _connect = null;
    protected DefaultFactory _factory = null;

    public DefaultRelation(Connection connect, DefaultFactory factory) {
        this._connect = connect;
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean withSourceRelations(DBFolder dbDest) {
        boolean result = true;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT COUNT(*) FROM " + SQLTable.RELATIONS + " WHERE rel_dst_id = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, dbDest.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        result = resultSet.getInt(1) > 0;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultRelation::withSrcRelations(" + dbDest + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultRelation::withSrcRelations(" + dbDest + ")");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DBRelation> getSourceRelations(DBFolder dbDest) {
        ArrayList<DBRelation> result = new ArrayList<DBRelation>();
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT rel_src_id, rel_src_type, rel_dst_type FROM " + SQLTable.RELATIONS + " WHERE rel_dst_id = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, dbDest.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        long id = resultSet.getLong(1);
                        DBFolder dbSrc = this._factory.createFolderDAO().find(id);
                        if (dbSrc == null) continue;
                        String typeSrc = resultSet.getString(2);
                        String typeDst = resultSet.getString(3);
                        result.add(new DBRelation(dbSrc, typeSrc, dbDest, typeDst));
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            result = null;
            this.logSQLException(e, "DefaultRelation::getSrcRelations(" + dbDest + ")");
        }
        catch (Exception e) {
            result = null;
            this.logException(e, "DefaultRelation::getSrcRelations(" + dbDest + ")");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DBRelation> getDestinationRelations(DBFolder dbSrc) {
        ArrayList<DBRelation> result = new ArrayList<DBRelation>();
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT rel_src_type, rel_dst_id, rel_dst_type FROM " + SQLTable.RELATIONS + " WHERE rel_src_id = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, dbSrc.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        long id = resultSet.getLong(2);
                        DBFolder dbDest = this._factory.createFolderDAO().find(id);
                        if (dbSrc == null) continue;
                        String typeSrc = resultSet.getString(1);
                        String typeDst = resultSet.getString(3);
                        result.add(new DBRelation(dbSrc, typeSrc, dbDest, typeDst));
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            result = null;
            this.logSQLException(e, "DefaultRelation::getDstRelations(" + dbSrc + ")");
        }
        catch (Exception e) {
            result = null;
            this.logException(e, "DefaultRelation::getDstRelations(" + dbSrc + ")");
        }
        return result;
    }

    @Override
    public boolean updateRelations(DBFolder dbSrc, String filterSrc, Collection<DBRelation> relations) {
        try {
            this.updateDestinationRelations(dbSrc, filterSrc, relations);
            return true;
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultRelation::getDstRelations(" + dbSrc + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultRelation::getDstRelations(" + dbSrc + ")");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDestinationRelations(DBFolder dbSrc, String filterSrc, Collection<DBRelation> relations) throws SQLException {
        PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.RELATIONS + " WHERE rel_src_id = ?" + (filterSrc != null ? " and rel_src_type = ?" : ""));
        this._factory.initStatement(prepare);
        try {
            prepare.setLong(1, dbSrc.getID());
            if (filterSrc != null) {
                prepare.setString(2, filterSrc);
            }
            prepare.executeUpdate();
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
        if (relations.size() > 0) {
            prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.RELATIONS + " (rel_src_id, rel_src_type, rel_dst_id, rel_dst_type) VALUES (?, ?, ?, ?)");
            this._factory.initStatement(prepare);
            try {
                for (DBRelation dbRelation : relations) {
                    if (!dbRelation.getSource().equals(dbSrc)) {
                        DefaultFactory._LOG.warning("Mise \u00e0 jour des relations avec une mauvaise source");
                        continue;
                    }
                    if (filterSrc != null && !filterSrc.equals(dbRelation.getTypeSource())) continue;
                    prepare.setLong(1, dbRelation.getSource().getID());
                    prepare.setString(2, dbRelation.getTypeSource());
                    prepare.setLong(3, dbRelation.getDestination().getID());
                    prepare.setString(4, dbRelation.getTypeDestination());
                    prepare.executeUpdate();
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

