/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.def;

import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.db.dao.DAOSession;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.TreeMap;
import java.util.logging.Level;

public class DefaultSession
extends DAOSession {
    protected Connection _connect = null;
    protected DefaultFactory _factory = null;
    boolean _bFreeze = false;

    public DefaultSession(Connection connect, DefaultFactory factory) {
        this._connect = connect;
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBSession create(DBSession obj) {
        try {
            long id;
            block20: {
                id = -1L;
                IUser curUser = obj.getUser();
                if (curUser instanceof DBUser && curUser.getID() <= 0L && (curUser = this._factory.createUserDAO().create((DBUser)curUser)) == null) {
                    return null;
                }
                PreparedStatement prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.SESSIONS + " (ses_usr_id, ses_module, ses_flags, ses_expire) VALUES (?, ?, ?, ?)", 1);
                this._factory.initStatement(prepare);
                try {
                    prepare.setLong(1, curUser.getID());
                    prepare.setString(2, obj.getModule());
                    prepare.setInt(3, obj.getFlags());
                    prepare.setLong(4, obj.getExpire());
                    int nbrChg = prepare.executeUpdate();
                    if (nbrChg != 1) break block20;
                    ResultSet resultSet = prepare.getGeneratedKeys();
                    try {
                        if (resultSet.next()) {
                            id = resultSet.getLong(1);
                        }
                    }
                    finally {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    try {
                        prepare.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (id != -1L) {
                return this.find(id);
            }
            this.logError("Error during DefaultSession::create(" + obj.getID() + "," + obj.getUser().getLogin() + ")");
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultSession::create(" + obj.getID() + "," + obj.getUser().getLogin() + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultSession::create(" + obj.getID() + "," + obj.getUser().getLogin() + ")");
        }
        return null;
    }

    @Override
    public boolean delete(DBSession obj) {
        boolean result = false;
        try {
            this._factory.beginTransaction(false);
            result = this.deleteInTransaction(obj);
            this._factory.endTransaction();
        }
        catch (Exception e) {
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                DefaultFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "DefaultSession::delete(" + obj.getID() + "," + obj.getUser().getLogin() + ")");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteInTransaction(DBSession session) throws SQLException {
        PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.RELATIONS + " WHERE rel_src_type = 'WORKING' AND rel_src_id IN (SELECT fol_id FROM " + SQLTable.OBJECTS + ", " + SQLTable.FOLDERS + " WHERE fol_obj_id = obj_id AND obj_ses_id = ?)");
        this._factory.initStatement(prepare);
        try {
            prepare.setLong(1, session.getID());
            prepare.executeUpdate();
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
        if (!session.isActive()) {
            prepare = this._connect.prepareStatement("UPDATE " + SQLTable.FOLDERS + " SET fol_time_update = " + this._factory.getSQLFunctionNow() + " WHERE fol_id IN (   SELECT fol_id FROM " + SQLTable.FOLDERS + ", " + SQLTable.OBJECTS + "      WHERE fol_obj_id = obj_id AND obj_ses_id = ?)");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, session.getID());
                prepare.executeUpdate();
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            int nbrUpdate = -1;
            PreparedStatement prepare2 = this._connect.prepareStatement("UPDATE " + SQLTable.OBJECTS + " SET obj_ses_id = NULL WHERE obj_ses_id = ?");
            this._factory.initStatement(prepare2);
            try {
                prepare2.setLong(1, session.getID());
                nbrUpdate = prepare2.executeUpdate();
            }
            finally {
                try {
                    prepare2.close();
                }
                catch (Exception exception) {}
            }
            if (nbrUpdate > 0) {
                DefaultFactory._LOG.info(Long.toString(nbrUpdate) + " objet(s) etai(en)t verrouille(s) par la session inactive '" + session.getID() + "' [user=" + session.getUser().getLogin() + "]");
            }
        }
        prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.SESSIONS + " WHERE ses_id = ?");
        this._factory.initStatement(prepare);
        try {
            prepare.setLong(1, session.getID());
            int nbrChg = prepare.executeUpdate();
            if (nbrChg == 1) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    @Override
    public void freeze(boolean bFreeze) {
        this._bFreeze = bFreeze;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(DBSession obj) {
        if (this._bFreeze) {
            return true;
        }
        try {
            PreparedStatement prepare = this._connect.prepareStatement("UPDATE " + SQLTable.SESSIONS + " SET ses_usr_id=?, ses_module=?, ses_flags=?, ses_expire=? WHERE ses_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getUser().getID());
                prepare.setString(2, obj.getModule());
                prepare.setInt(3, obj.getFlags());
                prepare.setLong(4, obj.getExpire());
                prepare.setLong(5, obj.getID());
                prepare.executeUpdate();
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            return true;
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultSession::update(" + obj.getID() + "," + obj.getUser().getLogin() + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultSession::update(" + obj.getID() + "," + obj.getUser().getLogin() + ")");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DBSession> findAll() {
        TreeMap<Long, DBSession> result = new TreeMap<Long, DBSession>();
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT ses_id, usr_id, usr_login, usr_flags, ses_module, ses_flags, ses_expire FROM " + SQLTable.SESSIONS + ", " + SQLTable.USERS + " WHERE ses_usr_id = usr_id", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        long id = resultSet.getLong(1);
                        DBSession obj = new DBSession(id, resultSet.getString(5));
                        obj.setUser(new IUser.MinimalUser(resultSet.getLong(2), resultSet.getString(3), resultSet.getInt(4)));
                        obj.setFlags(resultSet.getInt(6));
                        obj.setExpire(resultSet.getLong(7));
                        result.put(id, obj);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            result.clear();
            this.logSQLException(e, "DefaultSession::findAll()");
        }
        catch (Exception e) {
            result.clear();
            this.logException(e, "DefaultSession::findAll()");
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DBSession> findAll(IUser user) {
        TreeMap<Long, DBSession> result = new TreeMap<Long, DBSession>();
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT ses_id, ses_module, ses_flags, ses_expire FROM " + SQLTable.SESSIONS + ", " + SQLTable.USERS + " WHERE ses_usr_id = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, user.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        long id = resultSet.getLong(1);
                        DBSession obj = new DBSession(id, resultSet.getString(2));
                        obj.setUser(user);
                        obj.setFlags(resultSet.getInt(3));
                        obj.setExpire(resultSet.getLong(4));
                        result.put(id, obj);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            result.clear();
            this.logSQLException(e, "DefaultSession::findAll(" + user.getLogin() + ")");
        }
        catch (Exception e) {
            result.clear();
            this.logException(e, "DefaultSession::findAll(" + user.getLogin() + ")");
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBSession find(long id) {
        DBSession obj = null;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT usr_id, usr_login, usr_flags, ses_module, ses_flags, ses_expire FROM " + SQLTable.SESSIONS + ", " + SQLTable.USERS + " WHERE ses_usr_id = usr_id AND ses_id = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, id);
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        obj = new DBSession(id, resultSet.getString(4));
                        obj.setUser(new IUser.MinimalUser(resultSet.getLong(1), resultSet.getString(2), resultSet.getInt(3)));
                        obj.setFlags(resultSet.getInt(5));
                        obj.setExpire(resultSet.getLong(6));
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultSession::find(" + id + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultSession::find(" + id + ")");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countNbrSession(boolean expireSession, boolean notExpireSession) {
        int result = -1;
        try {
            String whereClause = "";
            if (expireSession && !notExpireSession) {
                whereClause = " WHERE ses_expire < ?";
            } else if (!expireSession && notExpireSession) {
                whereClause = " WHERE ses_expire >= ?";
            }
            PreparedStatement prepare = this._connect.prepareStatement("SELECT COUNT(*) FROM " + SQLTable.SESSIONS + whereClause, 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                if (expireSession || notExpireSession) {
                    long currentDate = new Date().getTime() / 1000L;
                    prepare.setLong(1, currentDate);
                }
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.next()) {
                        result = resultSet.getInt(1);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultSession::countNbrSession(" + expireSession + "," + notExpireSession + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultSession::countNbrSession(" + expireSession + "," + notExpireSession + ")");
        }
        return result;
    }
}

