/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.h2;

import com.dassault.cecilia.db.dao.sql.SQLConnection;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import com.dassault.cecilia.db.dao.sql.def.DefaultLicense;
import com.dassault.cecilia.db.dao.sql.def.DefaultSession;
import com.dassault.cecilia.db.dao.sql.h2.H2License;
import com.dassault.cecilia.db.dao.sql.h2.H2Session;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.logging.Logger;

public class H2Factory
extends DefaultFactory {
    static Logger _LOG = Logger.getLogger(H2Factory.class.getPackage().getName());
    public static final String JAVA_DATE_SQL_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public H2Factory(SQLConnection sqlConnect) {
        super(sqlConnect);
    }

    @Override
    public DefaultSession createSessionDAO() {
        if (this._daoSession == null) {
            this._daoSession = new H2Session(this._connect, this);
        }
        return this._daoSession;
    }

    @Override
    public DefaultLicense createLicenseDAO() {
        if (this._daoLicense == null) {
            this._daoLicense = new H2License(this._sqlConnect, this);
        }
        return this._daoLicense;
    }

    @Override
    public DateFormat createDateFormat() {
        if (this._dateFormat == null) {
            this._dateFormat = new SimpleDateFormat(JAVA_DATE_SQL_PATTERN, Locale.ENGLISH);
        }
        return this._dateFormat;
    }
}

