/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.mysql;

import com.dassault.cecilia.db.DBGroup;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import com.dassault.cecilia.db.dao.sql.def.DefaultGroup;
import com.dassault.cecilia.db.dao.sql.mysql.MySQLFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

public class MySQLGroup
extends DefaultGroup {
    public MySQLGroup(Connection connect, DefaultFactory factory) {
        super(connect, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(DBGroup obj) {
        int nbrLockObj = Integer.MAX_VALUE;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT COUNT(*) FROM " + SQLTable.OBJECTS + " WHERE obj_ses_id IN (SELECT ses_id FROM " + SQLTable.SESSIONS + " WHERE ses_usr_id IN (SELECT DISTINCT usr_id FROM " + SQLTable.USERS + ", " + SQLTable.GROUPS + ", " + SQLTable.GRP_USR + " WHERE grp_grp_id = grp_id AND grp_usr_id = usr_id AND grp_id = ?) )");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        nbrLockObj = resultSet.getInt(1);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "MySQLUser::delete(" + obj.getID() + ")");
        }
        if (nbrLockObj > 0) {
            MySQLFactory._LOG.severe("MySQLGroup::delete(" + obj.getID() + ") : Impossible de supprimer des sessions (via les groups et les users) qui verouillent des objets " + nbrLockObj);
            return false;
        }
        try {
            this._factory.beginTransaction(false);
            PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.SESSIONS + " WHERE ses_usr_id IN (SELECT DISTINCT usr_id FROM " + SQLTable.USERS + ", " + SQLTable.GROUPS + ", " + SQLTable.GRP_USR + " WHERE grp_grp_id = grp_id AND grp_usr_id = usr_id AND grp_id = ?)");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                prepare.executeUpdate();
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception e) {}
            }
            super.delete(obj);
            this._factory.endTransaction();
            return true;
        }
        catch (Exception e) {
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                MySQLFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "MySQLGroup::delete(" + obj.getID() + "," + obj.getName() + ")");
            return false;
        }
    }
}

