/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.mysql;

import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import com.dassault.cecilia.db.dao.sql.def.DefaultUser;
import com.dassault.cecilia.db.dao.sql.mysql.MySQLFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

public class MySQLUser
extends DefaultUser {
    public MySQLUser(Connection connect, DefaultFactory factory) {
        super(connect, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(DBUser obj) {
        int nbrLockObj = Integer.MAX_VALUE;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT COUNT(*) FROM " + SQLTable.OBJECTS + " WHERE obj_ses_id IN (SELECT ses_id FROM " + SQLTable.SESSIONS + " WHERE ses_usr_id = ?)");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        nbrLockObj = resultSet.getInt(1);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "MySQLUser::delete(" + obj.getID() + ")");
        }
        if (nbrLockObj > 0) {
            MySQLFactory._LOG.severe("MySQLUser::delete(" + obj.getID() + ") : Impossible de supprimer des sessions (via les users) qui verouille des objets " + nbrLockObj);
            return false;
        }
        try {
            this._factory.beginTransaction(false);
            PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.SESSIONS + " WHERE ses_usr_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                prepare.executeUpdate();
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception e) {}
            }
            super.delete(obj);
            this._factory.endTransaction();
            return true;
        }
        catch (Exception e) {
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                MySQLFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "MySQLGroup::delete(" + obj.getID() + "," + obj.getName() + ")");
            return false;
        }
    }
}

