/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.oracle;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;

public class TestTimeOut {
    String dbConn = "jdbc:oracle:thin:@127.0.0.1:1521:XE";
    String dbUser = "system";
    String dbPass = "welcome1";
    Connection conn = null;
    CallableStatement cs = null;

    public void callORCL() throws Exception {
        this.callORCL(5, 0);
    }

    public void callORCL(int sleepSec) throws Exception {
        this.callORCL(sleepSec, 0);
    }

    public void callORCL(int sleepSec, int queryTimeout) throws Exception {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        this.conn = DriverManager.getConnection(this.dbConn, this.dbUser, this.dbPass);
        String plsqlSleep = "begin\nDBMS_LOCK.sleep(" + sleepSec + ");\nend;\n";
        this.cs = this.conn.prepareCall(plsqlSleep);
        this.cs.setQueryTimeout(queryTimeout);
        this.cs.execute();
        this.cs.close();
        this.conn.close();
    }

    public static void main(String[] args) {
        System.out.println("Test1. oracle.net.READ_TIMEOUT");
        System.out.println("------------------------------");
        TestTimeOut test1 = new TestTimeOut();
        System.setProperty("oracle.net.READ_TIMEOUT", "2000");
        try {
            test1.callORCL(5);
            System.out.println("Failed! Operation not stopped!");
        }
        catch (Exception e) {
            System.out.println("Success! Operation time out!");
            System.out.println("Exception:" + e.getClass());
            System.out.println("Message  :" + e.getMessage());
        }
        System.getProperties().remove("oracle.net.READ_TIMEOUT");
        System.out.println();
        System.out.println("Test2. oracle.jdbc.ReadTimeout");
        System.out.println("------------------------------");
        System.setProperty("oracle.jdbc.ReadTimeout", "2000");
        TestTimeOut test2 = new TestTimeOut();
        try {
            test2.callORCL(5);
            System.out.println("Failed! Operation not stopped!");
        }
        catch (Exception e) {
            System.out.println("Success! Operation time out!");
            System.out.println("Exception:" + e.getClass());
            System.out.println("Message  :" + e.getMessage());
        }
        System.getProperties().remove("oracle.jdbc.ReadTimeout");
        System.out.println();
        System.out.println("Test3. setQueryTimeout");
        System.out.println("----------------------");
        TestTimeOut test3 = new TestTimeOut();
        try {
            test3.callORCL(5, 4);
            System.out.println("Failed! Operation not stopped!");
        }
        catch (Exception e) {
            System.out.println("Success! Operation time out!");
            System.out.println("Exception:" + e.getClass());
            System.out.println("Message  :" + e.getMessage());
        }
        System.out.println();
        System.out.println("Test4. oracle.jdbc.ReadTimeout < setQueryTimeout");
        System.out.println("-------------------------------------------------");
        TestTimeOut test4 = new TestTimeOut();
        System.setProperty("oracle.jdbc.ReadTimeout", "2000");
        try {
            test4.callORCL(5, 4);
            System.out.println("Failed! Operation not stopped!");
        }
        catch (Exception e) {
            System.out.println("Success! Operation time out!");
            System.out.println("Exception:" + e.getClass());
            System.out.println("Message  :" + e.getMessage());
        }
        System.getProperties().remove("oracle.jdbc.ReadTimeout");
        System.out.println();
        System.out.println("Test5. Thread.interrupt()");
        System.out.println("-------------------------");
        TestTimeOut test5 = new TestTimeOut();
        System.setProperty("oracle.jdbc.javaNetNio", "true");
        class DBThread
        extends Thread {
            TestTimeOut _orclAccess;

            DBThread() {
            }

            public void setOrclAccess(TestTimeOut orclAccess) {
                this._orclAccess = orclAccess;
            }

            @Override
            public void run() {
                try {
                    this._orclAccess.callORCL(5);
                    System.out.println("Failed! Operation not stopped!");
                }
                catch (Exception e) {
                    System.out.println("Success! Operation time out!");
                    System.out.println("Exception:" + e.getClass());
                    System.out.println("Message  :" + e.getMessage());
                }
            }
        }
        DBThread dbThread5 = new DBThread();
        dbThread5.setOrclAccess(test5);
        try {
            dbThread5.start();
            Thread.sleep(1000L);
            dbThread5.interrupt();
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.getProperties().remove("oracle.jdbc.javaNetNio");
        System.out.println();
        System.out.println("Test6. statement.cancel()");
        System.out.println("-------------------------");
        TestTimeOut test6 = new TestTimeOut();
        DBThread dbThread6 = new DBThread();
        dbThread6.setOrclAccess(test6);
        try {
            dbThread6.start();
            Thread.sleep(1000L);
            test6.cs.cancel();
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

