/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.seq;

import com.dassault.cecilia.db.DBLicense;
import com.dassault.cecilia.db.dao.sql.SQLConnection;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultLicense;
import com.dassault.cecilia.db.dao.sql.seq.SeqFactory;
import com.dassault.cecilia.lib.util.CryptUtility;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;

public class SeqLicense
extends DefaultLicense {
    public SeqLicense(SQLConnection sqlConnect, SeqFactory factory) {
        super(sqlConnect, factory);
    }

    @Override
    protected int doInsert(DBLicense obj) throws SQLException {
        String company = obj.getCompany();
        String module = obj.getModule();
        StringBuilder sqlQuery = new StringBuilder(320).append("INSERT INTO " + SQLTable.LICENSES + " (lic_id, lic_company, lic_module, lic_version, lic_host, lic_token, lic_expire)");
        sqlQuery.append(" VALUES (").append(((SeqFactory)this._factory).getSQLNextVal(SQLTable.LICENSES));
        sqlQuery.append(", ?, ?, ?, ?, ?, ?)");
        PreparedStatement prepare = this._connect.prepareStatement(sqlQuery.toString());
        this._factory.initStatement(prepare);
        try {
            int col = 1;
            prepare.setString(col++, company);
            prepare.setString(col++, module);
            prepare.setString(col++, CryptUtility.cryptData((String)obj.getVersion(), (String)company));
            prepare.setString(col++, CryptUtility.cryptData((String)obj.getHost(), (String)company));
            prepare.setString(col++, CryptUtility.cryptData((String)DBLicense.printToken(obj.getToken()), (String)company));
            prepare.setString(col++, CryptUtility.cryptData((String)DBLicense.printDate(obj.getExpire()), (String)company));
            int n = prepare.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            sqlQuery.append("[").append(company);
            sqlQuery.append(",").append(module);
            sqlQuery.append(",").append(obj.getVersion());
            sqlQuery.append(",").append(obj.getHost());
            sqlQuery.append(",").append(DBLicense.printToken(obj.getToken()));
            sqlQuery.append(",").append(DBLicense.printDate(obj.getExpire()));
            sqlQuery.append("]");
            SeqFactory._LOG.fine("sqlQuery=" + sqlQuery.toString());
            throw e;
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected DBLicense specificFind(long id, String module, String company, String host, String version, int token, Date expire) {
        if (company.equals("Dassault Aviation") && (host.isEmpty() || host.equals(".") || host.equals(System.getProperty("cecilia.db.user")))) {
            DBLicense obj = new DBLicense(id);
            obj.setCompany(company).setModule(module).setHost(host);
            obj.setVersion(version).setToken(token).setExpire(expire);
            return obj;
        }
        return null;
    }
}

