/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree;

import com.dassault.cecilia.core.plugin.AbstractInfoDatum;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.InfoDatum;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;

public class TreeInfoCompute
extends AbstractInfoDatum
implements IModel {
    private static Logger _LOG = Logger.getLogger(TreeInfoCompute.class.getPackage().getName());
    public static final String HEADER = "Tree.Compute.";
    public static final String ABSTRACT = ".Abstract";
    public static final String HEADER_XML = "<?xml";
    public static final String XML_ELT_DOC = "cecilia.datum";
    public static final String XML_ELT_TREE = "tree";
    public static final String XML_ELT_COMPUTE = "compute";
    public static final String XML_ATT_PATH = "path";
    public static final String XML_ATT_ID = "id";
    public static final String XML_ATT_CLOSE_IF_OPEN = "closeIfOpen";
    public static final String XML_ATT_UNLOCK = "unlock";
    public static final String XML_ATT_SAVE = "save";
    public static final String XML_ATT_TYPE = "type";
    public static final String XML_ATT_CONFIG = "config";
    public static final String XML_ATT_ROOT = "root";
    public static final String XML_ELT_EXPORT = "export";
    public static final String KEY_FILE_DAG = "ceciliabdd.file.dag";
    public static final String KEY_FILE_XML = "ceciliabdd.file.xml";
    public static final String KEY_FILE_RESULT = "result";
    public static final String KEY_FILE_RESULT_PARAMS = "result.parameters";
    public static final String KEY_FILE_RESULT_ABSTRACT = "result.abstract";
    public static final String KEY_FILE_RESULT_CUTS = "result.cuts";
    public static final String KEY_FILE_RESULT_MEL = "result.mel";
    public static final String KEY_INFO_COMPUTE = "Compute";
    public static final String KEY_INFO_CONFIG = "Config";
    public static final String KEY_INFO_ROOT = "Root";
    public static final String KEY_INFO_CRC_XML = "CRC.Xml";
    public static final String KEY_INFO_CRC_XML_OK = "CRC.Xml.equals";
    public static final String KEY_INFO_USER = "User";
    public static final String KEY_INFO_FULL_DATA = "FullData";
    public static final String KEY_INFO_RESULT_SAVE = "result.save";
    public static final String KEY_INFO_TREE_OPEN = "tree.open";
    public static final String KEY_INFO_TREE_LOCK = "tree.lock";
    public static final String KEY_INFO_ERROR = "tree.error";
    boolean _bMustBeSaveToDB = true;

    public TreeInfoCompute(InfoDatum isource) {
        super(isource);
        this._parameters.remove(KEY_INFO_RESULT_SAVE);
        this._parameters.remove(KEY_INFO_TREE_OPEN);
        this._parameters.remove(KEY_INFO_TREE_LOCK);
    }

    @Override
    public InfoDatum createCopy() {
        return new TreeInfoCompute(this);
    }

    public TreeInfoCompute(InputStream stream) throws IOException {
        super(stream);
    }

    public TreeInfoCompute(String key, String compute, long uid) {
        super(key);
        this._parameters.put(KEY_INFO_COMPUTE, compute);
        this._parameters.put("ID", Long.toString(uid));
    }

    @Override
    public IModel getModel() {
        return this;
    }

    @Override
    public String getFormat() {
        return "aralia.file";
    }

    @Override
    public File getFile() {
        return this.getInputFiles().get(KEY_FILE_DAG);
    }

    @Override
    public String getName() {
        return this.getParameters().get(KEY_INFO_ROOT);
    }

    @Override
    public String getConfig() {
        return this.getParameters().get(KEY_INFO_CONFIG);
    }

    @Override
    public long getUID() {
        String uid = this.getParameters().get("ID");
        if (uid == null) {
            _LOG.warning("No UID parameter for compute tree: " + this._parameters);
            return -1L;
        }
        return Long.parseLong(uid);
    }

    public boolean mustBeSaveToDB() {
        return this._bMustBeSaveToDB;
    }

    @Override
    protected boolean fileException(String keyFile) {
        if (keyFile.equals(KEY_FILE_DAG)) {
            return true;
        }
        return keyFile.equals(KEY_FILE_XML);
    }

    @Override
    protected boolean verifyInformations(Map<String, String> params) {
        if (params.get("Key") == null) {
            return false;
        }
        if (params.get("CRC") == null) {
            return false;
        }
        if (params.get(KEY_INFO_COMPUTE) == null) {
            return false;
        }
        if (params.get(KEY_INFO_CONFIG) == null) {
            return false;
        }
        return params.get(KEY_INFO_CRC_XML) != null;
    }

    @Override
    public void setKey(String key) {
        this._key = key;
        this._parameters.put("Key", key);
    }
}

