/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ccf.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.faulttree.ccf.io.CCFXmlConstants;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.io.LawHandlerXml;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CCFHandlerXml
extends SAXWrapHandler
implements CCFXmlConstants {
    CECFactory _cecFactory;
    CCF.CCFType _type;
    double[] _args;
    Law _law;
    LawHandlerXml _lawHandler = null;

    public CCFHandlerXml(DBLogs.DBLogsManager logMng, CECFactory cecFactory, Locator locator) {
        super(logMng, locator);
        this._cecFactory = cecFactory;
        this._type = null;
        this._args = new double[4];
        this._law = null;
    }

    public CCF.CCFType getType() {
        return this._type;
    }

    public double[] getArgs() {
        return this._args;
    }

    public Law getLaw() {
        return this._law;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            String attr;
            if (!"cec.ccf".equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", "cec.ccf"), this.getLocator()));
            }
            if ((attr = attrs.get("type")) == null || attr.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "type"), this.getLocator()));
            } else {
                this._type = (CCF.CCFType)CCFHandlerXml.valueOfEnum(CCF.CCFType.class, (String)attr.toUpperCase());
                if (this._type == null) {
                    this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "type", attr), this.getLocator()));
                    this._type = CCF.CCFType.BETA;
                }
            }
        } else if (this._lawHandler != null) {
            this._lawHandler.startAction(key, attrs, false);
        } else if ("ccf.factor".equals(key)) {
            int level = this.readPositiveInteger(key, "level", attrs, false, 0);
            double value = this.readDouble(key, "value", attrs, false, Double.NaN);
            if (level < 0 || level >= 4) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "level", Integer.toString(level)), this.getLocator()));
            } else {
                this._args[level] = value;
            }
        } else if ("law".equals(key)) {
            this._lawHandler = new LawHandlerXml(this.getLogManager(), this.getLocator(), this._cecFactory, this._cecFactory.getLawManager()){

                @Override
                protected String getOwnerObject() {
                    return ResMsgArbor.getString("VOC_CCF");
                }
            };
            this._lawHandler.startAction(key, attrs, true);
        } else {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._lawHandler != null) {
            boolean result = this._lawHandler.endAction(name, attrs, txt);
            if (result) {
                if ("law".equals(name)) {
                    this._law = this._lawHandler.getLaw();
                }
                this._lawHandler = null;
            }
            return false;
        }
        boolean result = "cec.ccf".equals(name);
        if (result && this._law == null) {
            this.warning(new SAXParseException(ResMsgObj.getString("MSG_ERR_DBMOD_LAW_NO_DISTRIB"), this.getLocator()));
            this._law = this._cecFactory.getLawManager().createLaw(-1);
        }
        return result;
    }
}

