/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ccf.io;

import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.io.LawParserRaw;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.lib.util.io.BasicLexer;
import java.util.logging.Logger;

public class CCFReaderRaw {
    private static Logger _LOG = Logger.getLogger(CCFReaderRaw.class.getPackage().getName());
    DBLogs.DBLogsManager _logManager;
    CCF.CCFType _type;
    double[] _args;
    Law _law;
    private static final String _FORMAT_RAW = "type=CCF_TY....;arg0=<float>;arg1=<float>;arg2=<float>;arg3=<float>;law=<law>";
    private static final String CCF_TYP_AL = "CCF_TYP_AL";
    private static final String CCF_TYP_BE = "CCF_TYP_BE";
    private static final String CCF_TY_MGL = "CCF_TY_MGL";

    public CCFReaderRaw(DBLogs.DBLogsManager logMng) {
        this._logManager = logMng;
        this._type = null;
        this._args = new double[4];
        this._law = null;
    }

    public CCF.CCFType getType() {
        return this._type;
    }

    public double[] getArgs() {
        return this._args;
    }

    public Law getLaw() {
        return this._law;
    }

    public boolean readRaw(String data, CECFactory cecFactory) {
        String type;
        BasicLexer lex = new BasicLexer(data){

            protected char readCharNumber(char car) {
                if (car == ',') {
                    return '.';
                }
                return super.readCharNumber(car);
            }
        };
        boolean result = false;
        if (lex.readNextWord(false).equals("type") && lex.readNextChar() == '=' && !(type = lex.readNextWord(false)).isEmpty()) {
            if (type.equals(CCF_TYP_BE)) {
                this._type = CCF.CCFType.BETA;
            } else if (type.equals(CCF_TYP_AL)) {
                this._type = CCF.CCFType.ALPHA;
            } else if (type.equals(CCF_TY_MGL)) {
                this._type = CCF.CCFType.MGL;
            }
            if (this._type != null) {
                String refLaw;
                int i;
                for (i = 0; i < 4; ++i) {
                    String id;
                    double arg = Double.NaN;
                    if (lex.readNextChar() == ';' && !(id = lex.readNextWord(true)).isEmpty() && id.equals("arg" + i) && lex.readNextChar() == '=') {
                        arg = lex.readNextNumber();
                    }
                    if (Double.isNaN(arg)) break;
                    this._args[i] = arg;
                }
                if (i == 4 && lex.readNextChar() == ';' && lex.readNextWord(false).equals("law") && lex.readNextChar() == '=' && !(refLaw = lex.readUntil('\u0000')).isEmpty()) {
                    LawParserRaw parser = new LawParserRaw(cecFactory.getLawManager(), cecFactory);
                    this._law = parser.parseLaw(refLaw);
                    if (this._law == null) {
                        parser.traceError(this._logManager, refLaw, _LOG);
                        this._law = cecFactory.getLawManager().createLaw(-1);
                    }
                    result = true;
                }
            }
        }
        if (!result) {
            this._logManager.addLog(DBLogs.DBLevel.ERROR, ResMsgArbor.msgFormat("MSG_ERR_DBCCF_RAW_FORMAT", data, _FORMAT_RAW));
        }
        return result;
    }
}

