/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.config.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class FTConfigDlgEdit
extends JDialogCecilia {
    private FTEquation _ftEquation;
    private FTConfig _ftConfig;
    JTextField _ctrlName;
    JTextArea _ctrlRemark;
    private JCheckBox _isCritComputeCB;
    JTabbedPane _configPanel;
    private JTable _dsfTable;
    private DSFModel _dsfModel;
    private JTable _ccfTable;
    private CCFModel _ccfModel;
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected boolean _bEditable = true;
    Component _southComponent = null;
    String _configInitName;
    HashSet<String> _setNameTaboo = new HashSet();

    public FTConfigDlgEdit(Window win) {
        super(win, ResMsgArbor.getString("CFG_DLG_TITLE"), true);
        this.make();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(win));
    }

    public boolean isEditable() {
        return this._bEditable;
    }

    public void setEditable(boolean value) {
        if (this._bEditable == value) {
            return;
        }
        this._bEditable = value;
        this._ctrlName.setEditable(this._bEditable);
        this._ctrlRemark.setEditable(this._bEditable);
        this._isCritComputeCB.setEnabled(this._bEditable);
        if (this._southComponent != null) {
            this.remove(this._southComponent);
        }
        Component component = this._southComponent = this._bEditable ? this.createButPanel() : this.createButPanelClose();
        if (this._southComponent != null) {
            this.add(this._southComponent, "South");
        }
    }

    public void setConfig(FTConfig config, List<FTConfig> allConfigs, FTEquation ftEquation) {
        this._ftConfig = config;
        this._ftEquation = ftEquation;
        this._setNameTaboo.clear();
        for (FTConfig otherConfig : allConfigs) {
            if (otherConfig.getName().equals(config.getName())) continue;
            this._setNameTaboo.add(otherConfig.getName());
        }
        this._configInitName = config.getName();
        this._ctrlName.setText(this._configInitName);
        this._ctrlRemark.setText(config.getLabel());
        this._isCritComputeCB.setSelected(config.isCritCompute());
        this._isCritComputeCB.setEnabled(!config.isCritCompute() && this.isEditable());
        if (this._configPanel.getTabCount() > 1) {
            this._configPanel.removeTabAt(1);
        }
        if (!this._ftEquation.isBigTree()) {
            this._configPanel.addTab(ResMsgArbor.getString("CFG_DLG_CCF"), new JScrollPane(this._ccfTable));
        }
        this._dsfModel.fireTableDataChanged();
        this._ccfModel.fireTableDataChanged();
    }

    protected void make() {
        this.init();
        this.setLayout(new BorderLayout());
        JPanel north = new JPanel(new GridBagLayout());
        JLabel lblName = new JLabel(ResMsgVoc.getString("VOC_NAME"));
        this._ctrlName = new JTextField();
        JLabel lblRemark = new JLabel(ResMsgVoc.getString("VOC_COMMENTS"));
        this._ctrlRemark = new JTextArea(3, 25);
        JScrollPane scrollRemark = new JScrollPane(this._ctrlRemark);
        this._isCritComputeCB = new JCheckBox(ResMsgArbor.getString("CFG_DLG_CRITICITY_COMPUTE"));
        north.add((Component)lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)this._ctrlName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)lblRemark, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)scrollRemark, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)this._isCritComputeCB, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this._configPanel = new JTabbedPane();
        this._configPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this._dsfModel = new DSFModel();
        this._dsfTable = new JTable(this._dsfModel);
        this._dsfTable.setPreferredScrollableViewportSize(new Dimension(400, 150));
        this._dsfTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this._dsfTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this._dsfTable.getColumnModel().getColumn(2).setPreferredWidth(50);
        this._dsfTable.setDefaultRenderer(Boolean.class, new ConfigItemBooleanRenderer());
        this._dsfTable.setDefaultRenderer(FTConfig.DSFConfigItem.class, new ConfigItemRenderer());
        this._configPanel.addTab(ResMsgArbor.getString("CFG_DLG_DSF"), new JScrollPane(this._dsfTable));
        this._ccfModel = new CCFModel();
        this._ccfTable = new JTable(this._ccfModel);
        this._ccfTable.setPreferredScrollableViewportSize(new Dimension(400, 150));
        this._ccfTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this._ccfTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this._ccfTable.setDefaultRenderer(Boolean.class, new ConfigItemBooleanRenderer());
        this._ccfTable.setDefaultRenderer(FTConfig.CCFConfigItem.class, new ConfigItemRenderer());
        this.add((Component)north, "North");
        this.add((Component)this._configPanel, "Center");
        this._southComponent = this.createButPanel();
        this.add(this._southComponent, "South");
        this.pack();
        Dimension minSize = this.getSize();
        minSize.height = minSize.height * 3 / 4;
        minSize.width = minSize.width * 2 / 3;
        this.setMinimumSize(minSize);
    }

    @Override
    protected boolean verifyParameters() {
        String name = this._ctrlName.getText().trim();
        if (name.isEmpty()) {
            String title = ResMsgVoc.getString("VOC_NAME");
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlName), ResMsgCore.msgFormat("MSG_ERR_FIELD_EMPTY", title), this.getTitle(), 0);
            this._ctrlName.requestFocus();
            return false;
        }
        if ((name = FTConfig.verifyName(name, this._ctrlName)) == null) {
            return false;
        }
        if (this._setNameTaboo.contains(name)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlName), ResMsgArbor.getString("ERR_CONFIG_ALREADY"), this.getTitle(), 0);
            this._ctrlName.requestFocus();
            return false;
        }
        this._ftConfig.setName(name);
        this._ftConfig.setLabel(this._ctrlRemark.getText());
        boolean isComputeForCriticity = this._isCritComputeCB.isSelected();
        if (isComputeForCriticity) {
            for (FTConfig conf : this._ftEquation.getConfigs()) {
                conf.setCritCompute(false);
            }
        }
        this._ftConfig.setCritCompute(isComputeForCriticity);
        return true;
    }

    class DSFModel
    extends AbstractTableModel {
        DSFModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResMsgArbor.getString("CFG_DLG_DSF_ITEM");
                }
                case 1: {
                    return ResMsgArbor.getString("CFG_DLG_DSF_FRB");
                }
                case 2: {
                    return ResMsgArbor.getString("CFG_DLG_DSF_SUBTREE");
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return FTConfig.DSFConfigItem.class;
                }
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public int getRowCount() {
            if (FTConfigDlgEdit.this._ftConfig == null) {
                return 0;
            }
            return FTConfigDlgEdit.this._ftConfig.getDSFItemsView().size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FTConfig.DSFConfigItem dsfItem = FTConfigDlgEdit.this._ftConfig.getDSFItemsView().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return dsfItem;
                }
                case 1: {
                    if (dsfItem.isOnlyFRB()) {
                        return true;
                    }
                    if (!dsfItem.isEnable()) {
                        return false;
                    }
                    return dsfItem.isFRB();
                }
                case 2: {
                    if (!dsfItem.isEnable()) {
                        return false;
                    }
                    return !dsfItem.isFRB();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!FTConfigDlgEdit.this.isEditable()) {
                return false;
            }
            switch (columnIndex) {
                case 0: {
                    return false;
                }
                case 1: 
                case 2: {
                    FTConfig.DSFConfigItem dsfItem = FTConfigDlgEdit.this._ftConfig.getDSFItemsView().get(rowIndex);
                    return dsfItem.isEnable();
                }
            }
            return super.isCellEditable(rowIndex, columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            FTConfig.DSFConfigItem dsfItem = FTConfigDlgEdit.this._ftConfig.getDSFItemsView().get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    dsfItem.setFRB((Boolean)aValue);
                    break;
                }
                case 2: {
                    dsfItem.setFRB((Boolean)aValue == false);
                    break;
                }
                default: {
                    return;
                }
            }
            this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        }
    }

    class CCFModel
    extends AbstractTableModel {
        CCFModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResMsgArbor.getString("CFG_DLG_CCF");
                }
                case 1: {
                    return "Select";
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return FTConfig.CCFConfigItem.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public int getRowCount() {
            if (FTConfigDlgEdit.this._ftConfig == null) {
                return 0;
            }
            return FTConfigDlgEdit.this._ftConfig.getCCFItems().size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FTConfig.CCFConfigItem item = FTConfigDlgEdit.this._ftConfig.getCCFItems().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return item;
                }
                case 1: {
                    return item.isSelected();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!FTConfigDlgEdit.this.isEditable()) {
                return false;
            }
            switch (columnIndex) {
                case 0: {
                    return false;
                }
                case 1: 
                case 2: {
                    FTConfig.CCFConfigItem item = FTConfigDlgEdit.this._ftConfig.getCCFItems().get(rowIndex);
                    return item.isEnable();
                }
            }
            return super.isCellEditable(rowIndex, columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                FTConfig.CCFConfigItem item = FTConfigDlgEdit.this._ftConfig.getCCFItems().get(rowIndex);
                item.setSelected((Boolean)aValue);
            }
        }
    }

    class ConfigItemBooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        public ConfigItemBooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            FTConfig.ConfigItem dsfItem = (FTConfig.ConfigItem)table.getValueAt(row, 0);
            this.setEnabled(dsfItem.isEnable());
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    class ConfigItemRenderer
    extends DefaultTableCellRenderer {
        ConfigItemRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FTConfig.ConfigItem dsfItem = (FTConfig.ConfigItem)table.getValueAt(row, 0);
            this.setEnabled(dsfItem.isEnable());
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

