/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.config.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.dsf.DSFEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.io.FTXmlConstant;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FTConfigHandlerXml
extends SAXWrapHandler
implements FTXmlConstant {
    protected CECFactory _daoFactory;
    FTConfig _ftConfig;

    public FTConfigHandlerXml(DBLogs.DBLogsManager manager, Locator locator, CECFactory daoFactory) {
        super(manager, locator);
        this._daoFactory = daoFactory;
    }

    public FTConfig getConfig() {
        return this._ftConfig;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            if (!"ft.cfg".equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", "ft.cfg"), this.getLocator()));
            }
            String name = this.readName(key, "name", attrs);
            this._ftConfig = new FTConfig().setName(name);
            boolean isCriticityCompute = this.readBoolean(key, "criticity.compute", attrs, true, false);
            this._ftConfig.setCritCompute(isCriticityCompute);
        } else if ("ft.cfg.dsf".equals(key)) {
            boolean isFRB = true;
            String type = attrs.get("type");
            if (type == null || type.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "type"), this.getLocator()));
            }
            if (type.equals("event")) {
                isFRB = true;
            } else if (type.equals("tree")) {
                isFRB = false;
            } else {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "type", type), this.getLocator()));
            }
            DBFolder dbFolder = this.readDBFolder(key, attrs, this._daoFactory.createFolderDAO(), DBFolder.Family.PROJECT.getRootName(), true);
            if (dbFolder != null) {
                if (dbFolder.getFamily() != DBFolder.Family.PROJECT) {
                    this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{dbFolder.getRefPath(), DBFolder.Family.PROJECT}), this.getLocator()));
                    dbFolder = null;
                } else if (dbFolder.getFamilyFlag() != 3) {
                    this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY_FLAG", dbFolder.getRefPath(), "DSF"), this.getLocator()));
                    dbFolder = null;
                }
            }
            if (dbFolder != null) {
                DBWrap dbWrap = this._daoFactory.findOrCreateWrap(dbFolder);
                if (dbWrap == null) {
                    this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_XML_MODEL_EVENT_READ", dbFolder.getRefPath()), this.getLocator()));
                } else {
                    DSFEquation dbDSF = (DSFEquation)dbWrap;
                    FTConfig.DSFConfigItem configItem = new FTConfig.DSFConfigItem(dbFolder);
                    if (dbDSF.getSubTree() == null) {
                        configItem.setOnlyFRB(true);
                    } else {
                        configItem.setFRB(isFRB);
                    }
                    this._ftConfig.addDSFItem(configItem);
                }
            }
        } else if ("ft.cfg.ccf".equals(key)) {
            boolean isSelected = true;
            String value = attrs.get("value");
            if (value == null || value.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "value"), this.getLocator()));
            }
            if (value.equals("true")) {
                isSelected = true;
            } else if (value.equals("false")) {
                isSelected = false;
            } else {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "value", value), this.getLocator()));
            }
            DBFolder dbFolder = this.readDBFolder(key, attrs, this._daoFactory.createFolderDAO(), DBFolder.Family.CCF_MODEL.getRootName(), true);
            if (dbFolder != null) {
                if (dbFolder.getFamily() != DBFolder.Family.CCF_MODEL) {
                    this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{dbFolder.getRefPath(), DBFolder.Family.CCF_MODEL}), this.getLocator()));
                } else if (dbFolder != null) {
                    DBWrap dbWrap = this._daoFactory.findOrCreateWrap(dbFolder);
                    if (dbWrap == null) {
                        this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_XML_MODEL_EVENT_READ", dbFolder.getRefPath()), this.getLocator()));
                    }
                    this._ftConfig.addCCFItem(new FTConfig.CCFConfigItem(dbFolder).setSelected(isSelected));
                }
            }
        } else if (!"label".equals(key)) {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        if ("label".equals(key)) {
            this._ftConfig.setLabel(txt);
            return false;
        }
        if ("ft.cfg".equals(key)) {
            this._ftConfig.sortConfigs();
            return true;
        }
        return false;
    }
}

