/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.egli;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOGlobEvent;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventAbstract;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventExtract;
import com.dassault.cecilia.dbobj.faulttree.egli.gui.EventGlobalListFrame;
import com.dassault.cecilia.dbobj.faulttree.egli.gui.EventGlobalListSelectionPanel;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdWithError;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class EGLICmdExtract
extends DBFolderCmdWithError {
    private static Logger _LOG = Logger.getLogger(EGLICmdExtract.class.getPackage().getName());
    Component _ctrlOwner;
    DBUser _dbUser;
    List<DBFolder> _selFolders;

    public EGLICmdExtract(CeciliaAppl appl, DBFolderTree owner, ArrayList<DBFolder> selFolders, DBUser user) {
        super((CAppl)appl, owner);
        this._ctrlOwner = owner;
        this._selFolders = selFolders;
        this._dbUser = user;
    }

    @Override
    protected String getTitle() {
        return ResMsgObj.getString("EGL_TITLE") + " - " + ResMsgVoc.getString("VOC_EXTRACT");
    }

    @Override
    protected CeciliaAppl getAppl() {
        return (CeciliaAppl)super.getAppl();
    }

    @Override
    protected boolean prepareDo() {
        LinkedHashSet<DBFolder> foldersToExport = new LinkedHashSet<DBFolder>();
        HashSet<DBFolder> treatsRecup = new HashSet<DBFolder>();
        if (this._selFolders != null && !this._selFolders.isEmpty()) {
            this.recupAllFolderObject(this._selFolders, foldersToExport, treatsRecup, this.getAppl().getDAOFactory().createFolderDAO());
        }
        ArrayList folders = new ArrayList(foldersToExport);
        EventGlobalListSelectionPanel.EventGlobalListSelectionDlg dlg = new EventGlobalListSelectionPanel.EventGlobalListSelectionDlg(SwingUtilities.getWindowAncestor(this._ctrlOwner), this.getAppl(), folders){

            @Override
            protected boolean verifyParameters() {
                EGLICmdExtract.this._selFolders = this.getSelectedFolders();
                if (EGLICmdExtract.this._selFolders.isEmpty()) {
                    _LOG.finest("CmdExport-Phase1: Pas de donnees a exporter");
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(EGLICmdExtract.this._ctrlOwner), ResMsgObj.getString("EGL_MSG_NO_TREE"), this.getTitle(), 1);
                    return false;
                }
                return super.verifyParameters();
            }

            @Override
            protected void validDialog() {
                super.validDialog();
                if (this.getResult()) {
                    CThread thread = new CThread(EGLICmdExtract.this._ctrlOwner){

                        @Override
                        protected void firstDo() {
                            EGLICmdExtract.this.extractDo();
                        }
                    };
                    thread.realiseDo();
                }
            }
        };
        dlg.setVisible(true);
        return false;
    }

    @Override
    protected void firstDo() {
        throw new IllegalAccessError();
    }

    protected void extractDo() {
        DAOGlobEvent daoGlobEvent = this.getAppl().getDAOFactory().createGlobEventDAO();
        ArrayList dbGlogEvents = new ArrayList(this._selFolders.size() * 100);
        for (DBFolder dbFolder : this._selFolders) {
            if (dbFolder.getObject() == null) continue;
            Collection<DBGlobEvent> dbCurrEvents = daoGlobEvent.findAll(dbFolder);
            if (dbCurrEvents == null) {
                this.addError(dbFolder, MsgType.ERROR, ResMsgObj.msgFormat("EGL_MSG_EXTRACT_ERROR", dbFolder.getRefPath()));
                continue;
            }
            if (dbCurrEvents.size() == 0) {
                this.addError(dbFolder, MsgType.WARNING, ResMsgObj.msgFormat("EGL_MSG_EXTRACT_EMPTY", dbFolder.getRefPath()));
                continue;
            }
            dbGlogEvents.addAll(dbCurrEvents);
        }
        CECFactory cecFactory = this.getAppl().getDAOFactory();
        ArrayList<FTGlobEventAbstract> ftGlobEvents = new ArrayList<FTGlobEventAbstract>(dbGlogEvents.size());
        for (DBGlobEvent dbGlobEvent : dbGlogEvents) {
            FTGlobEventExtract ftGlobEvent = new FTGlobEventExtract(dbGlobEvent);
            if (!ftGlobEvent.extract(cecFactory)) {
                this.addError(dbGlobEvent.getFolder(), MsgType.ERROR, ResMsgObj.msgFormat("EGL_MSG_CONVERT_ERROR", dbGlobEvent.getFolder().getRefPath(), dbGlobEvent.getName()));
                continue;
            }
            ftGlobEvents.add(ftGlobEvent);
        }
        if (ftGlobEvents.size() == 0) {
            this.addError(this._selFolders.get(0), MsgType.FATAL, ResMsgObj.getString("EGL_MSG_NO_DATA"));
            this.displayErrors(this.getErrors());
            return;
        }
        if (this.withWarnning()) {
            this.displayErrors(this.getErrors());
        }
        EventGlobalListFrame frame = new EventGlobalListFrame(ftGlobEvents, this.getAppl());
        frame.showView(this.getAppl().getTopWindow().getDesktop());
    }

    protected void recupAllFolderObject(List<DBFolder> folders, Set<DBFolder> recups, Set<DBFolder> treats, DAOFolder daoFolder) {
        for (int i = 0; i < folders.size(); ++i) {
            DBFolder dbFolder = folders.get(i);
            if (treats.contains(dbFolder)) continue;
            treats.add(dbFolder);
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                children = daoFolder.findChildren(dbFolder);
            }
            this.recupAllFolderObject(children, recups, treats, daoFolder);
            if (dbFolder.getObject() == null || !dbFolder.isVersion() || dbFolder.getFamilyFlag() != 2 && dbFolder.getFamilyFlag() != 3 && dbFolder.getFamilyFlag() != 5 || daoFolder.getAccessRight(dbFolder, this._dbUser) == DBAccess.Right.NONE) continue;
            if (!dbFolder.isFreeze() && dbFolder.isLocked()) {
                DBSession dbSession = dbFolder.getObject().getLockedSession();
                this.addError(dbFolder, MsgType.WARNING, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISLOCKED", dbFolder.getRefPath(), dbSession.getUser().getLogin(), dbSession.isActive() ? "" : " ~"));
            }
            recups.add(dbFolder);
        }
    }
}

