/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.egli;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdWithError;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class EGLICmdGenerate
extends DBFolderCmdWithError {
    private static Logger _LOG = Logger.getLogger(EGLICmdGenerate.class.getPackage().getName());
    Component _ctrlOwner;
    DBUser _dbUser;
    DBFolder _srcFolder;
    ArrayList<DBFolder> _selFolders;

    public EGLICmdGenerate(CeciliaAppl appl, DBFolderTree owner, ArrayList<DBFolder> selFolders, DBUser user) {
        super((CAppl)appl, owner);
        this._ctrlOwner = owner;
        this._selFolders = selFolders;
        this._srcFolder = appl.getDAOFactory().createFolderDAO().getRootID("PROJECTS");
        if (this._selFolders.size() == 0) {
            this._selFolders = new ArrayList(1);
            this._selFolders.add(this._srcFolder);
        } else if (this._selFolders.size() == 1) {
            this._srcFolder = this._selFolders.get(0);
        }
        this._dbUser = user;
    }

    @Override
    protected String getTitle() {
        return ResMsgObj.getString("EGL_TITLE") + " - " + ResMsgVoc.getString("VOC_GENERATE");
    }

    @Override
    protected CeciliaAppl getAppl() {
        return (CeciliaAppl)super.getAppl();
    }

    protected void recupAllFolderObject(List<DBFolder> folders, Set<DBFolder> recups, Set<DBFolder> treats, DAOFolder daoFolder) {
        for (int i = 0; i < folders.size(); ++i) {
            DBFolder dbFolder = folders.get(i);
            if (treats.contains(dbFolder)) continue;
            treats.add(dbFolder);
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                children = daoFolder.findChildren(dbFolder);
            }
            this.recupAllFolderObject(children, recups, treats, daoFolder);
            if (dbFolder.getObject() == null || !dbFolder.isVersion() || dbFolder.getFamilyFlag() != 2 && dbFolder.getFamilyFlag() != 3 && dbFolder.getFamilyFlag() != 5 || daoFolder.getAccessRight(dbFolder, this._dbUser) == DBAccess.Right.NONE) continue;
            if (!dbFolder.isFreeze() && dbFolder.isLocked()) {
                DBSession dbSession = dbFolder.getObject().getLockedSession();
                this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISLOCKED", dbFolder.getRefPath(), dbSession.getUser().getLogin(), dbSession.isActive() ? "" : " ~"));
                continue;
            }
            recups.add(dbFolder);
        }
    }

    @Override
    protected boolean prepareDo() {
        return true;
    }

    @Override
    protected void firstDo() {
        LinkedHashSet<DBFolder> foldersToExport = new LinkedHashSet<DBFolder>();
        HashSet<DBFolder> treatsRecup = new HashSet<DBFolder>();
        this.recupAllFolderObject(this._selFolders, foldersToExport, treatsRecup, this.getAppl().getDAOFactory().createFolderDAO());
        if (foldersToExport.size() == 0 && !this.withWarnning()) {
            _LOG.finest("CmdExport-Phase1: Pas de donnees a generer");
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlOwner), ResMsgObj.getString("EGL_MSG_NO_TREE"), this.getTitle(), 1);
            return;
        }
        CECFactory cecFactory = this.getAppl().getDAOFactory();
        int nbrGenerate = 0;
        int nbrError = 0;
        if (this.withWarnning()) {
            nbrError = this.getErrors().size();
        }
        for (DBFolder dbFolder : foldersToExport) {
            if (dbFolder.getObject() == null) continue;
            DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                this.addError(dbFolder, MsgType.ERROR, ResMsgCore.msgFormat("MSG_ERR_LOAD_MODEL_FRM", dbFolder.getRefPath(), ResMsgVoc.getString("VOC_TREE")));
                ++nbrError;
                continue;
            }
            FTEquationAbstract ftEquation = (FTEquationAbstract)dbWrap;
            if (ftEquation.getLogs().getMaxLevel() == DBLogs.DBLevel.ERROR) {
                this.addError(dbFolder, MsgType.ERROR, ResMsgObj.msgFormat("EGL_MSG_GENERATE_TREE_ERR", dbFolder.getRefPath()));
                ++nbrError;
                continue;
            }
            Collection<DBGlobEvent> dbEGLI = ftEquation.createGlobalEvents(ftEquation.getDBFolder());
            if (!cecFactory.createGlobEventDAO().insertAll(dbFolder, dbEGLI)) {
                this.addError(dbFolder, MsgType.ERROR, ResMsgObj.msgFormat("EGL_MSG_GENERATE_INSERT_ERR", dbFolder.getRefPath()));
                ++nbrError;
                continue;
            }
            ++nbrGenerate;
        }
        this.addError(this._srcFolder, MsgType.INFO, ResMsgObj.msgFormat("EGL_MSG_GENERATE_ABSTRACT", nbrGenerate, nbrError));
        this.displayErrors(this.getErrors());
    }

    public static boolean GenerateEGLI(CECFactory cecFactory, DBFolder dbFolder) {
        DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
        if (dbWrap == null) {
            return false;
        }
        if (!(dbWrap instanceof FTEquationAbstract)) {
            return false;
        }
        FTEquationAbstract ftEquation = (FTEquationAbstract)dbWrap;
        if (ftEquation.getLogs().getMaxLevel() == DBLogs.DBLevel.ERROR) {
            return ftEquation.getLogs().getMaxLevel(true) != DBLogs.DBLevel.ERROR;
        }
        Collection<DBGlobEvent> dbEGLI = ftEquation.createGlobalEvents(ftEquation.getDBFolder());
        return cecFactory.createGlobEventDAO().insertAll(dbFolder, dbEGLI);
    }
}

